/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.kafka;

import java.util.Properties;
import jmind.base.lang.SourceProperties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerUtill {
    private static final Logger logger = LoggerFactory.getLogger(KafkaProducerUtill.class);

    private KafkaProducerUtill() {
    }

    public static void sendMessage(String topic, String key, String value) {
        try {
            KafkaServerUtilHolder.producer.send(new ProducerRecord(topic, (Object)key, (Object)value));
            logger.info("kafkaProducerStatistic-topic:[{}],key:[{}]", (Object)topic, (Object)key);
        }
        catch (Exception e) {
            logger.error("send kafka message error!", (Throwable)e);
        }
    }

    private static class KafkaServerUtilHolder {
        private static KafkaProducer<String, String> producer;

        private KafkaServerUtilHolder() {
        }

        static {
            try {
                Properties props = new Properties();
                props.put("bootstrap.servers", SourceProperties.getDataSource().getProperty("bootstrap.servers"));
                props.put("acks", "1");
                props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                props.put("client.id", SourceProperties.getDataSource().getProperty("client.id"));
                producer = new KafkaProducer(props);
            }
            catch (Exception e) {
                logger.error("kafka config error!", (Throwable)e);
            }
        }
    }
}

