/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;

public class MySQLSeq
extends AbstractColumnMaxValueIncrementer {
    private int increment = 1;
    private String query = "";

    public MySQLSeq(DataSource dataSource, String incrementerName, String columnName) {
        super(dataSource, incrementerName, columnName);
    }

    public MySQLSeq(DataSource dataSource, String incrementerName, String columnName, int increment, String query) {
        super(dataSource, incrementerName, columnName);
        this.increment = increment;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        long nextId = 0L;
        Connection con = DataSourceUtils.getConnection((DataSource)this.getDataSource());
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            DataSourceUtils.applyTransactionTimeout((Statement)stmt, (DataSource)this.getDataSource());
            String sql = "update " + this.getIncrementerName() + " set " + this.getColumnName() + " = last_insert_id(" + this.getColumnName() + " + " + this.increment + ") " + this.query;
            stmt.executeUpdate(sql);
            ResultSet rs = stmt.executeQuery("select last_insert_id()");
            try {
                if (!rs.next()) {
                    throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                }
                nextId = rs.getLong(1);
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", (Throwable)ex);
        }
        finally {
            JdbcUtils.closeStatement((Statement)stmt);
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
        }
        return nextId;
    }

    public long getNextKey(String query) {
        return this.getNextKey(this.getIncrementerName(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getNextKey(String tableName, String query) throws DataAccessException {
        long nextId = 0L;
        Connection con = DataSourceUtils.getConnection((DataSource)this.getDataSource());
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            DataSourceUtils.applyTransactionTimeout((Statement)stmt, (DataSource)this.getDataSource());
            String sql = "update " + tableName + " set " + this.getColumnName() + " = last_insert_id(" + this.getColumnName() + " + " + this.increment + ") " + query;
            stmt.executeUpdate(sql);
            ResultSet rs = stmt.executeQuery("select last_insert_id()");
            try {
                if (!rs.next()) {
                    throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                }
                nextId = rs.getLong(1);
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", (Throwable)ex);
        }
        finally {
            JdbcUtils.closeStatement((Statement)stmt);
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
        }
        return nextId;
    }
}

