/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmind.base.util.DataUtil;

public class Jdbc {
    private Connection con = null;

    public Jdbc(Connection con) {
        this.con = con;
    }

    public Jdbc(String path, String user, String pwd) throws SQLException {
        this("com.mysql.cj.jdbc.Driver", path, user, pwd);
    }

    public Jdbc(String driver, String path, String user, String pwd) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("driver not found:" + driver);
        }
        this.con = DriverManager.getConnection(path, user, pwd);
    }

    private void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<Integer, Object>> executeQuery(String sql) {
        ArrayList<Map<Integer, Object>> list = new ArrayList<Map<Integer, Object>>();
        try {
            Statement s = this.con.createStatement();
            ResultSet rs = s.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            for (int j = 1; j <= cols; ++j) {
                String colName = rsmd.getColumnName(j);
                map.put(j, colName);
            }
            list.add(map);
            while (rs.next()) {
                map = new HashMap();
                for (int i = 1; i <= cols; ++i) {
                    map.put(i, rs.getObject(i));
                }
                list.add(map);
            }
            rs.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeQuery(String sql, List<Object> params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            if (params != null) {
                for (int k = 0; k < params.size(); ++k) {
                    ps.setObject(k + 1, params.get(k));
                }
            }
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            HashMap<String, Object> map = null;
            while (rs.next()) {
                map = new HashMap<String, Object>();
                for (int i = 1; i <= cols; ++i) {
                    String name = rsmd.getColumnLabel(i);
                    if (DataUtil.isEmpty((String)name)) {
                        name = rsmd.getColumnName(i);
                    }
                    map.put(name, rs.getObject(i));
                }
                list.add(map);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult(String sql) {
        boolean has = false;
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                has = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return has;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> qureyColumn(String sql, List<Object> params) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            if (params != null) {
                for (int k = 0; k < params.size(); ++k) {
                    ps.setObject(k + 1, params.get(k));
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getObject(1));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return list;
    }

    public int getCounts(String sql) {
        Map<Integer, Object> map;
        Object obj;
        int num = 0;
        List<Map<Integer, Object>> list = this.executeQuery(sql);
        if (list.size() > 1 && (obj = (map = list.get(1)).get(1)) != null) {
            num = DataUtil.toInt((String)obj.toString());
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSQL(String sql) {
        int i = 0;
        try {
            Statement s = this.con.createStatement();
            i = s.executeUpdate(sql);
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(String ... sql) {
        int i = -100;
        try {
            Statement s = this.con.createStatement();
            for (String str : sql) {
                s.addBatch(str);
            }
            i = s.executeBatch()[0];
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSQL(String sql, List<Object> list) {
        int i = -100;
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            if (list != null) {
                for (int k = 0; k < list.size(); ++k) {
                    ps.setObject(k + 1, list.get(k));
                }
            }
            i = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return i;
    }
}

