/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import javax.sql.DataSource;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;

public class HikariDataSource {
    public DataSource getSource(String name, IProperties p) {
        String url = p.getProperty("jdbc." + name + ".url");
        System.out.println("jdbc." + name + ".url=" + url);
        if (DataUtil.isEmpty((String)url)) {
            return null;
        }
        com.zaxxer.hikari.HikariDataSource ds = new com.zaxxer.hikari.HikariDataSource();
        ds.setJdbcUrl(url);
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        if (url.startsWith("jdbc:oracle")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
        } else if (url.startsWith("jdbc:sqlserver")) {
            driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        ds.setDriverClassName(driverClassName);
        ds.setUsername(p.getProperty("jdbc." + name + ".username"));
        ds.setPassword(p.getProperty("jdbc." + name + ".password"));
        ds.setMinimumIdle(DataUtil.toInt((String)p.getProperty("jdbc." + name + ".maxIdle", "1")));
        int maxActive = DataUtil.toInt((String)p.getProperty("jdbc." + name + ".maxActive", "20"));
        ds.setMaximumPoolSize(maxActive);
        ds.setReadOnly(Boolean.parseBoolean(p.getProperty("jdbc." + name + ".slave")));
        return ds;
    }
}

