/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import javax.sql.DataSource;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import org.apache.commons.dbcp.BasicDataSource;

public class DbcpBasicDataSource {
    public DataSource getSource(String name, IProperties p) {
        String url = p.getProperty("jdbc." + name + ".url");
        System.out.println("jdbc." + name + ".url=" + url);
        if (DataUtil.isEmpty((String)url)) {
            return null;
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(url);
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        if (url.startsWith("jdbc:oracle")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            ds.setValidationQuery("SELECT * FROM DUAL");
        } else if (url.startsWith("jdbc:sqlserver")) {
            driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else {
            ds.setValidationQuery("SELECT 1");
        }
        ds.setDriverClassName(driverClassName);
        ds.setUsername(p.getProperty("jdbc." + name + ".username"));
        ds.setPassword(p.getProperty("jdbc." + name + ".password"));
        ds.setMaxIdle(DataUtil.toInt((String)p.getProperty("jdbc." + name + ".maxIdle", "10")));
        int maxActive = DataUtil.toInt((String)p.getProperty("jdbc." + name + ".maxActive", "20"));
        ds.setMaxActive(maxActive);
        ds.setDefaultReadOnly(Boolean.parseBoolean(p.getProperty("jdbc." + name + ".slave")));
        ds.setRemoveAbandoned(true);
        ds.setRemoveAbandonedTimeout(300);
        ds.setLogAbandoned(true);
        ds.setTestOnBorrow(false);
        ds.setTestOnReturn(false);
        ds.setTestWhileIdle(true);
        ds.setTimeBetweenEvictionRunsMillis(300000L);
        ds.setNumTestsPerEvictionRun(3);
        ds.setMinEvictableIdleTimeMillis(1800000L);
        return ds;
    }
}

