/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jmind.base.util.DataUtil;
import jmind.core.jdbc.BaseJdbc;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public abstract class BeanJdbc<E>
extends BaseJdbc {
    private static final String GETS = "select * from %s where %s=? limit ?,?";
    private volatile RowMapper<E> rm = null;
    private volatile SimpleJdbcInsert jdbcInsert;
    public String tableName = this.getType().getSimpleName().toLowerCase();

    public Class<E> getType() {
        ParameterizedType p = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)p.getActualTypeArguments()[0];
    }

    public RowMapper<E> getRowMapper() {
        if (this.rm == null) {
            this.rm = new BeanPropertyRowMapper(this.getType());
        }
        return this.rm;
    }

    public SimpleJdbcInsert getSimpleJdbcInsert() {
        if (this.jdbcInsert == null) {
            this.jdbcInsert = new SimpleJdbcInsert(this.getJdbc(0).getDataSource()).withTableName(this.tableName);
        }
        return this.jdbcInsert;
    }

    public int insert(E obj) {
        return super.insert(this.getSimpleJdbcInsert(), obj);
    }

    public int delete(String keyName, Object key) {
        return super.delete(this.tableName, keyName, key);
    }

    public E findOne(int source, String sql, Object ... args) {
        try {
            return (E)this.getJdbc(source).queryForObject(sql, this.getRowMapper(), args);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public List<E> find(int source, String sql, Object ... args) {
        List list = this.getJdbc(source).query(sql, this.getRowMapper(), args);
        return list;
    }

    public List<E> sFind(int source, String sql, SqlParameterSource args) {
        NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(this.getJdbc(source).getDataSource());
        List list = template.query(sql, args, this.getRowMapper());
        return list;
    }

    public E get(String keyName, Object key) {
        return this.findOne(String.format(GETS, this.tableName, keyName), key, 0, 1);
    }

    public E findOne(String sql, Object ... args) {
        return this.findOne(SLAVE_SOURCE, sql, args);
    }

    public List<E> find(String sql, Object ... args) {
        return this.find(SLAVE_SOURCE, sql, args);
    }

    public List<E> query(int offset, int limit) {
        return this.find("select * from " + this.tableName + " limit ?,?", offset, limit);
    }

    public List<E> query(String keyName, Object key, int offset, int limit) {
        return this.find(String.format(GETS, this.tableName, keyName), key, offset, limit);
    }

    public int findForInt(String sql, Object ... args) {
        return this.findForInt(SLAVE_SOURCE, sql, args);
    }

    public Map<String, Object> queryForMap(String tableName, String keyName, Object key) {
        return this.findForMap(String.format(GETS, tableName, keyName), key, 0, 1);
    }

    public Map<String, Object> findForMap(String sql, Object ... args) {
        return this.findForMap(SLAVE_SOURCE, sql, args);
    }

    public List<Map<String, Object>> findForList(String sql, Object ... args) {
        return this.findForList(SLAVE_SOURCE, sql, args);
    }

    public <T> T findColumValue(String sql, Class<T> requiredType, Object ... args) {
        return this.findColumValue(SLAVE_SOURCE, sql, requiredType, args);
    }

    public <T> List<T> findColumValues(String key, Class<T> requiredType, Object ... args) {
        return this.findColumValues(SLAVE_SOURCE, key, requiredType, args);
    }

    public List<E> sFind(String sql, SqlParameterSource args) {
        return this.sFind(SLAVE_SOURCE, sql, args);
    }

    public List<E> sFind(String sql, Collection<?> ids) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", ids);
        return this.sFind(SLAVE_SOURCE, sql, (SqlParameterSource)parameters);
    }

    public int count(String tableName) {
        if (DataUtil.isEmpty((String)tableName)) {
            tableName = this.tableName;
        }
        return this.findForInt("select count(1) from " + tableName, new Object[0]);
    }

    public int count(String tableName, String keyName, Object key) {
        if (DataUtil.isEmpty((String)tableName)) {
            tableName = this.tableName;
        }
        return super.findForInt(SLAVE_SOURCE, "select count(1) from " + tableName + " where " + keyName + "=?", key);
    }
}

