/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import jmind.base.util.DataUtil;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;

public abstract class BaseJdbc {
    public static final int MASTER_SOURCE = 0;
    public static int SLAVE_SOURCE = 1;
    public static final String LAST_ID_SQL = "select last_insert_id()";

    public abstract JdbcTemplate getJdbc(int var1);

    public Number insertAndReturnKey(final String sql, final String keyName, final Object ... args) {
        Number key = 0;
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Integer affectRows = this.getJdbc(0).update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, new String[]{keyName});
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
                return ps;
            }
        }, (KeyHolder)keyHolder);
        if (affectRows > 0) {
            key = keyHolder.getKey();
        }
        return key;
    }

    public Number insertAndReturnKey(SimpleJdbcInsert jdbcInsert, Object obj) {
        BeanPropertySqlParameterSource parameters = new BeanPropertySqlParameterSource(obj);
        return jdbcInsert.executeAndReturnKey((SqlParameterSource)parameters);
    }

    public int insert(SimpleJdbcInsert jdbcInsert, Object obj) {
        BeanPropertySqlParameterSource parameters = new BeanPropertySqlParameterSource(obj);
        int i = jdbcInsert.execute((SqlParameterSource)parameters);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exeAndReturnLastId(String sql) {
        DataSource dataSource = this.getJdbc(0).getDataSource();
        Connection con = DataSourceUtils.getConnection((DataSource)dataSource);
        Statement stmt = null;
        int lastId = 0;
        try {
            stmt = con.createStatement();
            DataSourceUtils.applyTransactionTimeout((Statement)stmt, (DataSource)dataSource);
            stmt.executeUpdate(sql);
            ResultSet rs = stmt.executeQuery(LAST_ID_SQL);
            try {
                if (!rs.next()) {
                    throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                }
                lastId = rs.getInt(1);
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", (Throwable)ex);
        }
        finally {
            JdbcUtils.closeStatement((Statement)stmt);
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
        }
        return lastId;
    }

    public int update(String sql, Object ... args) {
        return this.getJdbc(0).update(sql, args);
    }

    public int delete(String tableName, String keyName, Object key) {
        return this.getJdbc(0).update("delete from " + tableName + " where " + keyName + "=?", new Object[]{key});
    }

    public int update(String tableName, String key, Object val, Map<String, Object> mark) {
        if (DataUtil.isEmpty(mark)) {
            return 0;
        }
        Object[] args = new Object[mark.size() + 1];
        StringBuilder sql = new StringBuilder("update " + tableName + " set ");
        int i = 0;
        for (Map.Entry<String, Object> entry : mark.entrySet()) {
            sql.append(entry.getKey()).append("= ?,");
            args[i++] = entry.getValue();
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ").append(key).append("=?");
        args[i] = val;
        return this.getJdbc(0).update(sql.toString(), args);
    }

    public <T> T findColumValue(int source, String sql, Class<T> requiredType, Object ... args) {
        try {
            return (T)this.getJdbc(source).queryForObject(sql, requiredType, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> List<T> findColumValues(int source, String sql, Class<T> requiredType, Object ... args) {
        return this.getJdbc(source).queryForList(sql, requiredType, args);
    }

    public int findForInt(int source, String sql, Object ... args) {
        try {
            return (Integer)this.getJdbc(source).queryForObject(sql, Integer.class, args);
        }
        catch (EmptyResultDataAccessException e) {
            return 0;
        }
    }

    public Map<String, Object> findForMap(int source, String sql, Object ... args) {
        try {
            return this.getJdbc(source).queryForMap(sql, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<Map<String, Object>> findForList(int source, String sql, Object ... args) {
        return this.getJdbc(source).queryForList(sql, args);
    }
}

