/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ip;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmind.base.util.DataUtil;

public class Location
implements Serializable {
    private String province;
    private String city;
    private String district;
    private String address;
    private int a;
    private Date b;
    private static Pattern k = Pattern.compile("^\u4e2d?\u56fd?([^\u7701]{2,3})\u7701([^\u5e02]{2,4})\u5e02(.*)$");
    private static Pattern z = Pattern.compile("^\u4e2d?\u56fd?([^\u81ea]{2,5})\u81ea\u6cbb\u533a([^\u5e02]{2,4})\u5e02(.*)$");
    private static Pattern p = Pattern.compile("^\u4e2d?\u56fd?(\u5317\u4eac|\u4e0a\u6d77|\u5929\u6d25|\u91cd\u5e86)\u5e02?([^\u533a\u53bf]{2,3}[\u533a\u53bf])(.*)$");
    private static Pattern p0 = Pattern.compile("^(\u5317\u4eac)\u5e02\u5e02\u8f96\u533a([^\u533a]{2,3}\u533a)(.*)$");
    private static Pattern p1 = Pattern.compile("^(\u5317\u4eac)\u5e02\u53bf([^\u53bf]{2,3}\u53bf)(.*)$");
    private static Pattern q = Pattern.compile("^([^\u5e02\u53bf\u533a]{2,4}[\u5e02\u53bf\u533a])(.*)$");
    private static Pattern Municipalities = Pattern.compile(".*(\u9999\u6e2f|\u6fb3\u95e8|\u5317\u4eac|\u4e0a\u6d77|\u5929\u6d25|\u91cd\u5e86|\u5185\u8499\u53e4|\u5e7f\u897f|\u65b0\u7586|\u5b81\u590f|\u897f\u85cf).*");

    public Location() {
    }

    public static Location parseProvice(String location) {
        Location l = new Location();
        l.address = location;
        int end = location.indexOf("\u7701");
        if (end > 0) {
            l.province = location.substring(0, end).trim();
        } else {
            Matcher matcher = Municipalities.matcher(location);
            if (matcher.matches()) {
                l.province = matcher.group(1);
            }
        }
        return l;
    }

    public Location(String address) {
        Matcher matcher;
        this.address = address;
        Matcher m = p0.matcher(address);
        boolean matched = m.matches();
        if (!matched) {
            m = p1.matcher(address);
            matched = m.matches();
        }
        if (!matched) {
            m = p.matcher(address);
            matched = m.matches();
        }
        if (matched) {
            this.city = m.group(1);
            this.district = m.group(2);
            this.province = this.city;
        } else {
            m = address.indexOf("\u81ea\u6cbb\u533a") > 0 ? z.matcher(address) : k.matcher(address);
            matched = m.matches();
            if (matched) {
                this.city = m.group(2);
                this.province = m.group(1);
                m = q.matcher(this.address);
                if (m.matches()) {
                    this.district = m.group(1);
                }
            }
        }
        if (DataUtil.isEmpty((String)this.city) && (matcher = Municipalities.matcher(address)).matches()) {
            this.city = this.province = matcher.group(1);
        }
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String provience) {
        this.province = provience;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return this.address;
    }

    public int getA() {
        return this.a;
    }

    public void setA(int a) {
        this.a = a;
    }

    public Date getB() {
        return this.b;
    }

    public void setB(Date b) {
        this.b = b;
    }

    public static void main(String[] args) {
        Location l = new Location("\u5e7f\u4e1c\u7701\u6df1\u5733\u5e02");
        System.out.println(l.getAddress());
        System.out.println(l.getProvince());
        System.out.println(l.getCity());
    }
}

