/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ip;

import java.io.IOException;
import jmind.base.util.DataUtil;
import jmind.core.ip.IPSeeker;
import jmind.core.ip.Location;
import jmind.core.log.LogUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IPApi {
    public static Location getLocation(String ip, IPSeeker p) {
        String pro = p.getCountry(ip);
        Location location = null;
        if (!DataUtil.isEmpty((String)pro)) {
            location = new Location(pro);
        }
        if ((location == null || DataUtil.isEmpty((String)location.getProvince())) && !DataUtil.isEmpty((String)(pro = IPApi.getByApi(ip)))) {
            location = new Location(pro);
        }
        return location;
    }

    public static String getByApi(String ip) {
        String address = IPApi.ip138(ip);
        if (address == null && (address = IPApi.pconline(ip)) == null) {
            address = IPApi.youdao(ip);
        }
        return address;
    }

    public static String ip138(String ip) {
        String api = "http://ip138.com/ips138.asp?action=2&ip=" + ip;
        try {
            int index;
            Thread.sleep(2000L);
            Document doc = Jsoup.connect((String)api).get();
            String data = doc.select("ul.ul1 >li").first().text();
            if (!DataUtil.isEmpty((String)data) && (index = data.indexOf("\uff1a")) > 0) {
                data = data.substring(index + 1);
            }
            return data;
        }
        catch (Exception e) {
            LogUtil.error(e);
            return null;
        }
    }

    public static String liqwei(String ip) {
        String api = "http://api.liqwei.com/location/?ip=" + ip;
        try {
            Document doc = Jsoup.connect((String)api).get();
            String body = doc.text();
            body = body.substring(body.indexOf(",") + 1);
            LogUtil.debug("liqwei,ip=" + ip + body);
            return body;
        }
        catch (IOException e) {
            LogUtil.error(e);
            return null;
        }
    }

    public static String pconline(String ip) {
        String api = "http://whois.pconline.com.cn/ip.jsp?ip=" + ip;
        try {
            Document doc = Jsoup.connect((String)api).get();
            String body = doc.text();
            LogUtil.debug("pconline,ip=" + ip + body);
            return body;
        }
        catch (IOException e) {
            LogUtil.error(e);
            return null;
        }
    }

    public static String youdao(String ip) {
        String api = "http://www.youdao.com/smartresult-xml/search.s?type=ip&q=" + ip;
        try {
            Document doc = Jsoup.connect((String)api).get();
            String body = doc.select("location").text();
            LogUtil.debug("youdao,ip=" + ip + body);
            return body;
        }
        catch (IOException e) {
            LogUtil.error(e);
            return null;
        }
    }

    public static void main(String[] arg) {
        String ip = "114.239.40.159";
        System.out.println(IPApi.ip138(ip));
    }
}

