/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image.ocr;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jmind.core.image.ocr.J2SEImage;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.data.QRCodeImage;

public class QRCodeImg {
    public static void main(String[] args) {
        try {
            String decode = QRCodeImg.decode("d:/data/2901.jpg");
            System.out.println(decode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void encode(String content, String FilePath) throws Exception {
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect('M');
        qrcode.setQrcodeEncodeMode('B');
        qrcode.setQrcodeVersion(7);
        byte[] d = content.getBytes("GBK");
        BufferedImage bi = new BufferedImage(139, 139, 1);
        Graphics2D g = bi.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, 139, 139);
        g.setColor(Color.BLACK);
        if (d.length > 0 && d.length < 123) {
            boolean[][] b = qrcode.calQrcode(d);
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < b.length; ++j) {
                    if (!b[j][i]) continue;
                    g.fillRect(j * 3 + 2, i * 3 + 2, 3, 3);
                }
            }
        }
        g.dispose();
        bi.flush();
        File f = new File(FilePath);
        ImageIO.write((RenderedImage)bi, "png", f);
    }

    public static String decode(String filePath) {
        QRCodeDecoder decoder = new QRCodeDecoder();
        File imageFile = new File(filePath);
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageFile);
            String decodedData = new String(decoder.decode((QRCodeImage)new J2SEImage(image)), "GBK");
            return decodedData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

