/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image.ocr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jmind.core.image.ocr.ImageIOHelper;
import org.jdesktop.swingx.util.OS;

public class OCR {
    private static final String LANG_OPTION = "-l";
    private static final String EOL = System.getProperty("line.separator");
    private static String tessPath = new File("/Users/wbxie/work/workspace/im20/jmind-core/doc/Tesseract-ocr").getAbsolutePath();

    public static void main(String[] args) {
        try {
            File parent = new File("/data/captcha/");
            System.out.println(OCR.macRecognize(new File("/data/captcha/vcodejsp3.jpg")));
            System.out.println("\u8bc6\u522b\u7ed3\u675f**********");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String macRecognize(File imageFile) {
        File outputFile = new File(imageFile.getParentFile(), "output");
        StringBuilder strB = new StringBuilder();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("tesseract");
        cmd.add(imageFile.getAbsolutePath());
        cmd.add(outputFile.getAbsolutePath());
        cmd.add(LANG_OPTION);
        cmd.add("eng");
        String commd = ((Object)cmd).toString().replace("[", "").replace("]", "").replace(",", "");
        System.out.println(commd);
        try {
            Process process = Runtime.getRuntime().exec("tesseract /data/captcha/vcodejsp3.jpg  /data/captcha/out -l eng");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String recognizeText(File imageFile, String imageFormat) throws Exception {
        BufferedReader in;
        File tempImage = ImageIOHelper.createImage(imageFile, imageFormat);
        File outputFile = new File(imageFile.getParentFile(), "output");
        StringBuffer strB = new StringBuffer();
        ArrayList<String> cmd = new ArrayList<String>();
        System.out.println(OS.isMacOSX() + outputFile.getName());
        if (OS.isWindowsXP()) {
            cmd.add(tessPath + "\\tesseract");
        } else if (OS.isMacOSX()) {
            cmd.add("tesseract");
        } else {
            cmd.add(tessPath + "\\tesseract");
        }
        cmd.add("");
        cmd.add(outputFile.getName());
        cmd.add(LANG_OPTION);
        cmd.add("chi_sim");
        cmd.add("eng");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(imageFile.getParentFile());
        System.out.println(tempImage.getName());
        cmd.set(1, tempImage.getName());
        pb.command(cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        int w = process.waitFor();
        System.out.println(w);
        if (w == 0) {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outputFile.getAbsolutePath() + ".txt"), "UTF-8"));
            while ((str = in.readLine()) != null) {
                strB.append(str).append(EOL);
            }
        } else {
            String msg;
            switch (w) {
                case 1: {
                    msg = "Errors accessing files. There may be spaces in your image's filename.";
                    break;
                }
                case 29: {
                    msg = "Cannot recognize the image or its selected region.";
                    break;
                }
                case 31: {
                    msg = "Unsupported image format.";
                    break;
                }
                default: {
                    msg = "Errors occurred.";
                }
            }
            tempImage.delete();
            throw new RuntimeException(msg);
        }
        in.close();
        new File(outputFile.getAbsolutePath() + ".txt").delete();
        return strB.toString();
    }
}

