/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;

public class ImgPro {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagickImage regulate(MagickImage source, String destPathName) throws MagickException {
        int width = (int)source.getDimension().getWidth();
        int height = (int)source.getDimension().getHeight();
        if (((double)height + 0.0) / (double)width > 1.5) {
            MagickImage scaled = null;
            try {
                int newHeight = (int)Math.round((double)width * 1.5);
                Rectangle rect = new Rectangle(0, (height - newHeight) / 2, width, newHeight);
                scaled = source.cropImage(rect);
                scaled.setFileName(destPathName);
                MagickImage magickImage = scaled;
                return magickImage;
            }
            finally {
                if (source != null) {
                    source.destroyImages();
                }
            }
        }
        return source;
    }

    public static MagickImage regulate(MagickImage source) throws MagickException {
        return ImgPro.regulate(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagickImage regulate(MagickImage source, boolean destroySource) throws MagickException {
        int width = (int)source.getDimension().getWidth();
        int height = (int)source.getDimension().getHeight();
        if (((double)height + 0.0) / (double)width > 1.5) {
            MagickImage scaled = null;
            try {
                int newHeight = (int)Math.round((double)width * 1.5);
                Rectangle rect = new Rectangle(0, (height - newHeight) / 2, width, newHeight);
                MagickImage magickImage = scaled = source.cropImage(rect);
                return magickImage;
            }
            finally {
                if (source != null && destroySource) {
                    source.destroyImages();
                }
            }
        }
        return source;
    }

    public static MagickImage regulateWithMinLimit(MagickImage source, int minWidth, int minHeight) throws MagickException {
        return ImgPro.regulateWithMinLimit(source, minWidth, minHeight, true);
    }

    public static MagickImage regulateWithMinLimit(MagickImage source, int minWidth, int minHeight, boolean destroyImage) throws MagickException {
        int width = (int)source.getDimension().getWidth();
        int height = (int)source.getDimension().getHeight();
        if (width < minWidth && height < minHeight) {
            MagickImage img = null;
            byte[] pixels = new byte[minWidth * minHeight * 4];
            for (int i = 0; i < minWidth * minHeight; ++i) {
                pixels[4 * i] = -1;
                pixels[4 * i + 1] = -1;
                pixels[4 * i + 2] = -1;
                pixels[4 * i + 3] = 0;
            }
            img = new MagickImage();
            img.constituteImage(minWidth, minHeight, "RGBA", pixels);
            img.compositeImage(2, source, (minWidth - width) / 2, (minHeight - height) / 2);
            if (destroyImage) {
                source.destroyImages();
            }
            return img;
        }
        if (width < minWidth) {
            return ImgPro.regulateWithRatio(source, minWidth, height, destroyImage);
        }
        if (height < minHeight) {
            return ImgPro.regulateWithRatio(source, width, minHeight, destroyImage);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagickImage regulateWithMaxWidth(MagickImage source, int maxWidth, boolean destroySource) throws MagickException {
        int width = (int)source.getDimension().getWidth();
        int height = (int)source.getDimension().getHeight();
        if ((double)(height / width) > 1.5 && width < maxWidth) {
            int y = (int)(((double)height - (double)maxWidth * 1.5) / 2.0);
            Rectangle rect = new Rectangle(0, y, width, (int)((double)maxWidth * 1.5));
            if (destroySource) {
                source.destroyImages();
            }
            return source.cropImage(rect);
        }
        MagickImage img = null;
        try {
            img = ImgPro.regulate(source, false);
            MagickImage magickImage = ImgPro.resizePhotoStep(img, img.getFileName(), maxWidth, (int)((double)maxWidth * 1.5));
            return magickImage;
        }
        finally {
            if (destroySource) {
                source.destroyImages();
            }
        }
    }

    public static MagickImage regulateWithRatio(MagickImage source, int ratioWidth, int ratioHeight) throws MagickException {
        return ImgPro.regulateWithRatio(source, ratioWidth, ratioHeight, true);
    }

    public static MagickImage regulateWithRatio(MagickImage source, int ratioWidth, int ratioHeight, boolean destroySource) throws MagickException {
        int width = (int)source.getDimension().getWidth();
        int height = (int)source.getDimension().getHeight();
        boolean okay = true;
        int newh = height;
        int neww = width;
        int x = 0;
        int y = 0;
        System.out.println(String.format("%d, %d", width, height));
        if ((float)width / (float)height > (float)ratioWidth / (float)ratioHeight) {
            newh = width * ratioHeight / ratioWidth;
            y = (newh - height) / 2;
            okay = false;
            System.out.println("w>h");
        } else if ((float)width / (float)height < (float)ratioWidth / (float)ratioHeight) {
            neww = height * ratioWidth / ratioHeight;
            x = (neww - width) / 2;
            okay = false;
            System.out.println("h>w");
        }
        MagickImage img = null;
        if (!okay) {
            System.out.println(String.format("%d, %d", neww, newh));
            byte[] pixels = new byte[neww * newh * 4];
            for (int i = 0; i < neww * newh; ++i) {
                pixels[4 * i] = -1;
                pixels[4 * i + 1] = -1;
                pixels[4 * i + 2] = -1;
                pixels[4 * i + 3] = 0;
            }
            img = new MagickImage();
            img.constituteImage(neww, newh, "RGBA", pixels);
            img.compositeImage(2, source, x, y);
            if (destroySource) {
                source.destroyImages();
            }
            return img;
        }
        return source;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("d:/data/800.jpg");
        byte[] blob = new byte[(int)f.length()];
        FileInputStream fis = new FileInputStream(f);
        fis.read(blob);
        MagickImage image = ImgPro.getMagickImage(blob);
        image = ImgPro.regulateWithMaxWidth(image, 50, false);
        image.setFileName("d:/pic/test2/dd3d.jpg");
        image.writeImage(new ImageInfo());
    }

    public static MagickImage resizePhotoStep(MagickImage source, String destPathName, int maxWidth, int maxHeight) throws MagickException {
        int width = 0;
        int height = 0;
        boolean change = true;
        width = (int)source.getDimension().getWidth();
        height = (int)source.getDimension().getHeight();
        if (maxWidth > width && maxHeight > height) {
            change = false;
        } else if (width > 0 && height > 0) {
            if (height / width > maxHeight / maxWidth) {
                width = width * maxHeight / height;
                height = maxHeight;
            } else {
                height = height * maxWidth / width;
                width = maxWidth;
            }
        }
        MagickImage scaled = null;
        scaled = change ? source.zoomImage(width, height) : source;
        scaled.setFileName(destPathName);
        return scaled;
    }

    public static MagickImage setcomment(MagickImage image, String comment) throws MagickException {
        image.profileImage("*", null);
        image.setImageAttribute("comment", comment);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertBmpToJpg(String srcPathName, String destPathName) throws MagickException {
        MagickImage image = null;
        try {
            ImageInfo info = null;
            info = new ImageInfo();
            image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
            image.setFileName(destPathName);
            image.writeImage(info);
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resize(String srcPathName, String destPathName, int maxWidth, int maxHeight) throws MagickException {
        int width = 0;
        int height = 0;
        boolean change = true;
        width = ImgPro.getWidth(srcPathName);
        height = ImgPro.getHeight(srcPathName);
        if (width > 0 && height > 0) {
            if (height / width > maxHeight / maxWidth) {
                width = width * maxHeight / height;
                height = maxHeight;
            } else {
                height = height * maxWidth / width;
                width = maxWidth;
            }
        }
        MagickImage image = null;
        MagickImage scaled = null;
        try {
            ImageInfo info = null;
            info = new ImageInfo();
            image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
            scaled = change ? image.scaleImage(width, height) : image;
            scaled.setFileName(destPathName);
            scaled.writeImage(info);
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
            if (scaled != null) {
                scaled.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resizePhoto(String srcPathName, String destPathName, int maxWidth, int maxHeight) throws MagickException {
        int width = 0;
        int height = 0;
        boolean change = true;
        width = ImgPro.getWidth(srcPathName);
        height = ImgPro.getHeight(srcPathName);
        if (maxWidth > width && maxHeight > height) {
            change = false;
        } else if (width > 0 && height > 0) {
            if (height / width > maxHeight / maxWidth) {
                width = width * maxHeight / height;
                height = maxHeight;
            } else {
                height = height * maxWidth / width;
                width = maxWidth;
            }
        }
        MagickImage image = null;
        MagickImage scaled = null;
        try {
            ImageInfo info = null;
            info = new ImageInfo();
            image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
            scaled = change ? image.scaleImage(width, height) : image;
            scaled.setFileName(destPathName);
            scaled.writeImage(info);
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
            if (scaled != null) {
                scaled.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setcomment(String srcPathName, String comment) throws MagickException {
        ImageInfo info = null;
        info = new ImageInfo();
        MagickImage image = null;
        try {
            image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
            image.profileImage("*", null);
            image.setImageAttribute("comment", comment);
            image.writeImage(info);
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
        }
    }

    public static boolean checkcomment(MagickImage source, String comment) {
        try {
            String cmt = "";
            cmt = source.getImageAttribute("comment");
            if (cmt != null && cmt.startsWith("renren") && !comment.equals(cmt)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkcomment(String srcPathName, String comment) throws MagickException {
        MagickImage image = null;
        try {
            image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
            String cmt = "";
            cmt = image.getImageAttribute("comment");
            if (cmt != null && cmt.startsWith("renren") && !comment.equals(cmt)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mask(String logoPath, String srcPathName, String destPathName, int location, int scale) throws MagickException {
        int width = ImgPro.getWidth(srcPathName);
        int height = ImgPro.getHeight(srcPathName);
        int x = 0;
        int y = 0;
        int w = scale * 70 / 100;
        int h = scale * 65 / 100;
        boolean lc = true;
        if (width < height) {
            switch (location) {
                case 0: {
                    lc = false;
                    break;
                }
                case 1: {
                    x = width / 4 - w;
                    y = height / 8 - h / 2;
                    break;
                }
                case 2: {
                    x = width / 2 - w;
                    y = height / 8 - h / 2;
                    break;
                }
                case 3: {
                    x = width * 3 / 4 - w;
                    y = height / 8 - h / 2;
                    break;
                }
                case 4: {
                    x = width / 4 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 5: {
                    x = width / 2 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 6: {
                    x = width * 3 / 4 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 7: {
                    x = width / 4 - w;
                    y = height * 7 / 8 - h / 2;
                    break;
                }
                case 8: {
                    x = width / 2 - w;
                    y = height * 7 / 8 - h / 2;
                    break;
                }
                case 9: {
                    x = width * 3 / 4 - w;
                    y = height * 7 / 8 - h / 2;
                }
            }
        } else {
            switch (location) {
                case 0: {
                    lc = false;
                    break;
                }
                case 1: {
                    x = width / 7 - w;
                    y = height / 6 - h / 2;
                    break;
                }
                case 2: {
                    x = width / 2 - w;
                    y = height / 6 - h / 2;
                    break;
                }
                case 3: {
                    x = width * 6 / 7 - w;
                    y = height / 6 - h / 2;
                    break;
                }
                case 4: {
                    x = width / 7 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 5: {
                    x = width / 2 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 6: {
                    x = width * 6 / 7 - w;
                    y = height / 2 - h / 2;
                    break;
                }
                case 7: {
                    x = width / 7 - w;
                    y = height * 5 / 6 - h / 2;
                    break;
                }
                case 8: {
                    x = width / 2 - w;
                    y = height * 5 / 6 - h / 2;
                    break;
                }
                case 9: {
                    x = width * 6 / 7 - w;
                    y = height * 5 / 6 - h / 2;
                }
            }
        }
        if (x < 10) {
            x = 10;
        }
        if (x + w * 2 + 10 > width) {
            x = width - w * 2 - 10;
        }
        if (y < 10) {
            y = 10;
        }
        if (y + h + 10 > height) {
            y = height - h - 10;
        }
        if (lc) {
            ImageInfo info = new ImageInfo();
            MagickImage image = null;
            MagickImage mask = null;
            MagickImage dest = null;
            try {
                image = new MagickImage(new ImageInfo(srcPathName + "[0]"));
                mask = new MagickImage(new ImageInfo(logoPath));
                image.setFileName(destPathName);
                image.writeImage(info);
                dest = new MagickImage(new ImageInfo(destPathName));
                dest.compositeImage(3, mask, x, y);
                dest.setFileName(destPathName);
                dest.writeImage(info);
            }
            finally {
                if (image != null) {
                    image.destroyImages();
                }
                if (mask != null) {
                    mask.destroyImages();
                }
                if (dest != null) {
                    dest.destroyImages();
                }
            }
        }
    }

    public static MagickImage getMagickImage(String src) throws MagickException {
        ImageInfo info = new ImageInfo(src + "[0]");
        return new MagickImage(info);
    }

    public static MagickImage getMagickImage(byte[] bt) throws MagickException {
        ImageInfo info = new ImageInfo("[0]");
        return new MagickImage(info, bt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWidth(String src) throws MagickException {
        MagickImage magImage = null;
        try {
            ImageInfo info = new ImageInfo(src + "[0]");
            magImage = new MagickImage(info);
            Dimension imageDim = magImage.getDimension();
            int n = imageDim.width;
            return n;
        }
        finally {
            if (magImage != null) {
                magImage.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHeight(String src) throws MagickException {
        MagickImage magImage = null;
        try {
            ImageInfo info = new ImageInfo(src + "[0]");
            magImage = new MagickImage(info);
            Dimension imageDim = magImage.getDimension();
            int n = imageDim.height;
            return n;
        }
        finally {
            if (magImage != null) {
                magImage.destroyImages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shrinkWidth(String srcPathName, String destPathName, int maxWidth) throws MagickException {
        int width = ImgPro.getWidth(srcPathName);
        int height = ImgPro.getHeight(srcPathName);
        if (width <= maxWidth) {
            return false;
        }
        int y = height * maxWidth / width;
        MagickImage image = null;
        MagickImage scaled = null;
        try {
            ImageInfo info = new ImageInfo();
            image = new MagickImage(new ImageInfo(srcPathName));
            scaled = image.scaleImage(maxWidth, y);
            scaled.setFileName(destPathName);
            scaled.writeImage(info);
            boolean bl = true;
            return bl;
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
            if (scaled != null) {
                scaled.destroyImages();
            }
        }
    }
}

