/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ibatis;

import java.util.List;
import jmind.core.ibatis.SqlSessionFactoryManager;
import org.apache.ibatis.exceptions.IbatisException;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlSessionWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSessionWrapper.class);
    private SqlSessionFactoryManager sqlSessionFactory;

    public SqlSessionWrapper(SqlSessionFactoryManager sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public Object selectOne(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.getSqlSession();
            Object object = sqlSession.selectOne(statement, parameter);
            return object;
        }
        catch (Throwable t) {
            LOG.error("selectOne(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("selectOne error:" + statement);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public List selectList(String statement, Object parameter, RowBounds rowBounds) {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.getSqlSession();
            List list = sqlSession.selectList(statement, parameter, rowBounds);
            return list;
        }
        catch (Throwable t) {
            LOG.error("selectList(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("selectList error:" + statement);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int insert(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.getSqlSession();
            int n = sqlSession.insert(statement, parameter);
            return n;
        }
        catch (Throwable t) {
            LOG.error("insert(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("insert error:" + statement);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int update(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.getSqlSession();
            int n = sqlSession.update(statement, parameter);
            return n;
        }
        catch (Throwable t) {
            LOG.error("update(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("update error:" + statement);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int delete(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.getSqlSession();
            int n = sqlSession.delete(statement, parameter);
            return n;
        }
        catch (Throwable t) {
            LOG.error("delete(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("delete error:" + statement);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public SqlSession getBatchSqlSession() {
        return this.sqlSessionFactory.getBatchSqlSession();
    }

    public SqlSession getSqlSession() {
        return this.sqlSessionFactory.getSqlSession();
    }

    public void initResource() {
        try (SqlSession sqlSession = null;){
            sqlSession = this.getSqlSession();
        }
    }

    public SqlSessionFactoryManager getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

