/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ibatis;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import jmind.base.util.DataUtil;
import jmind.core.ibatis.SqlSessionFactoryBean;
import jmind.core.manager.DataSourceManager;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSessionFactoryManager
extends DataSourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSessionFactoryManager.class);
    private static final String IBATIS_CONFIG_SUFFIX = "_ibatis.xml";
    private static final Object LOCK = new Object();
    private final Map<String, SqlSessionFactory> sqlSessionFactoryMap = new ConcurrentHashMap<String, SqlSessionFactory>();
    private String componentName;
    private String environment;
    private boolean isRead = Boolean.FALSE;
    private boolean isAutoCommit = Boolean.TRUE;

    public SqlSessionFactoryManager(String ibatisXml, String dbEnv) {
        this.componentName = ibatisXml;
        this.environment = dbEnv;
        this.isRead = Boolean.FALSE;
        this.isAutoCommit = Boolean.TRUE;
    }

    public void isRead(boolean isRead) {
        this.isRead = isRead;
    }

    public void isAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public SqlSession getSqlSession() {
        try {
            SqlSessionFactory sqlSessionFactory = this.getSqlSessionFactory();
            long start = System.currentTimeMillis();
            SqlSession session = sqlSessionFactory.openSession(this.isAutoCommit);
            long end = System.currentTimeMillis();
            if (end - start > 100L) {
                LOG.warn("open sql session:" + this.environment + " " + (end - start) + " millionSeconds");
            }
            return session;
        }
        catch (Exception e) {
            LOG.error("get getInstanceSqlSession error:" + e.getMessage());
            return null;
        }
    }

    public SqlSession getBatchSqlSession() {
        try {
            SqlSessionFactory sqlSessionFactory = this.getSqlSessionFactory();
            long start = System.currentTimeMillis();
            SqlSession session = sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            long end = System.currentTimeMillis();
            if (end - start > 100L) {
                LOG.warn("open sql session:" + this.environment + " " + (end - start) + " millionSeconds");
            }
            return session;
        }
        catch (Exception e) {
            LOG.error("get getInstanceSqlSession error:" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlSessionFactory getSqlSessionFactory() {
        Map<String, SqlSessionFactory> tempSqlSessionFactoryMap = this.sqlSessionFactoryMap;
        String environmentKey = this.componentName + "::" + this.environment;
        if (!tempSqlSessionFactoryMap.containsKey(environmentKey)) {
            Object object = LOCK;
            synchronized (object) {
                if (!tempSqlSessionFactoryMap.containsKey(environmentKey)) {
                    try {
                        System.out.println("......getSqlSessionFactory: componentName=" + this.componentName + " environment=" + this.environment);
                        if (DataUtil.isEmpty((String)this.componentName) || DataUtil.isEmpty((String)this.environment)) {
                            throw new Exception("\u53c2\u6570\u4e3a\u7a7a:componentName=" + this.componentName + " environment=" + this.environment);
                        }
                        LOG.info(String.format("build datasource:%s", environmentKey));
                        long start = System.currentTimeMillis();
                        SqlSessionFactory factory = this.buildSqlSessionFactory();
                        tempSqlSessionFactoryMap.put(environmentKey, factory);
                        long end = System.currentTimeMillis();
                        if (end - start > 1000L) {
                            LOG.info(String.format("build datasource %s cost %d ms", environmentKey, end - start));
                        }
                        return factory;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        LOG.error("build environment error environment:" + environmentKey + " componentName:" + this.componentName + " with error " + e.getMessage());
                        return null;
                    }
                }
            }
        }
        return tempSqlSessionFactoryMap.get(environmentKey);
    }

    private SqlSessionFactory buildSqlSessionFactory() throws IOException {
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        if (this.isRead) {
            sessionFactoryBean.setUseTransactionAwareDataSource(false);
        }
        sessionFactoryBean.setEnvironmentId(this.environment);
        DataSource ds = (DataSource)this.getResource(this.environment);
        sessionFactoryBean.setDataSource(ds);
        String ibatisConfigFile = this.componentName + IBATIS_CONFIG_SUFFIX;
        return sessionFactoryBean.buildSqlSessionFactory(ibatisConfigFile);
    }
}

