/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ibatis;

import java.io.IOException;
import java.io.Reader;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

class SqlSessionFactoryBean {
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = true;
    private String environmentId = "development";

    SqlSessionFactoryBean() {
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    protected SqlSessionFactory buildSqlSessionFactory(String configLocation) throws IOException {
        if (configLocation == null) {
            throw new IllegalArgumentException("configLocation entry is required");
        }
        DataSource dataSourceToUse = this.dataSource;
        if (this.useTransactionAwareDataSource && !(this.dataSource instanceof TransactionAwareDataSourceProxy)) {
            dataSourceToUse = new TransactionAwareDataSourceProxy(this.dataSource);
        }
        Environment environment = new Environment(this.environmentId, (TransactionFactory)new ManagedTransactionFactory(), dataSourceToUse);
        Reader reader = Resources.getResourceAsReader((String)configLocation);
        XMLConfigBuilder parser = new XMLConfigBuilder(reader, null, null);
        Configuration config = parser.parse();
        config.setEnvironment(environment);
        return new DefaultSqlSessionFactory(config);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

