/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import jmind.base.lang.Pair;
import jmind.base.util.DataUtil;
import jmind.base.util.IOUtil;
import jmind.base.util.RequestUtil;
import jmind.core.http.HttpClient;

public class HttpDefault
extends HttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String url, String code, int timeout) {
        long start = System.currentTimeMillis();
        String res = null;
        InputStream in = null;
        try {
            URL uri = new URL(url);
            URLConnection urlConnection = uri.openConnection();
            if (timeout > 0) {
                urlConnection.setReadTimeout(timeout);
            }
            in = uri.openStream();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            String s = null;
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            res = sb.toString();
            br.close();
            isr.close();
            this.success(start, url, res);
        }
        catch (IOException e) {
            this.fail(start, url, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(String url, String body, String code, int timeout) {
        long start = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        String res = null;
        try {
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Accept-Charset", code);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + code);
            if (timeout > 0) {
                urlConnection.setReadTimeout(timeout);
            }
            if (!DataUtil.isEmpty((String)body)) {
                urlConnection.setDoOutput(true);
                OutputStream outputStream = urlConnection.getOutputStream();
                outputStream.write(body.getBytes(code));
                outputStream.flush();
                outputStream.close();
            }
            InputStream in = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, code));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            res = builder.toString();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return res;
    }

    @Override
    public String post(String url, Map<String, ?> params, String code, int timeout) {
        return this.post(url, RequestUtil.toQueryString(params), code, timeout);
    }

    @Override
    public String post(String url, List<Pair<String, String>> params, String code, int timeout) {
        String queryString = null;
        if (!DataUtil.isEmpty(params)) {
            StringBuilder sb = new StringBuilder();
            for (Pair<String, String> pair : params) {
                sb.append("&").append((String)pair.getFirst()).append("=").append((String)pair.getSecond());
            }
            queryString = sb.substring(1);
        }
        return this.post(url, queryString, code, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postFile(String url, Map<String, ?> params, String fileName, File file, String code) {
        long start = System.currentTimeMillis();
        String boundary = Long.toHexString(start);
        HttpURLConnection conn = null;
        String res = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", code);
            conn.setRequestProperty("Accept-Charset", code);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            conn.connect();
            OutputStream outputStream = conn.getOutputStream();
            DataOutputStream ds = new DataOutputStream(outputStream);
            if (!DataUtil.isEmpty(params)) {
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    ds.writeBytes("--" + boundary + "\r\n");
                    ds.writeBytes("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n");
                    ds.writeBytes("\r\n");
                    ds.write(entry.getValue().toString().getBytes(code));
                    ds.writeBytes("\r\n");
                }
            }
            if (file != null) {
                ds.writeBytes("--" + boundary + "\r\n");
                ds.writeBytes("Content-Disposition: form-data; name=\"" + fileName + "\"; filename=\"");
                ds.write(file.getName().getBytes(code));
                ds.writeBytes("\"\r\n");
                ds.writeBytes("Content-Type: " + this.getContentType(file) + "\r\n");
                ds.writeBytes("\r\n");
                ds.write(IOUtil.getBytes((File)file));
                ds.writeBytes("\r\n");
            }
            ds.writeBytes("--" + boundary + "--" + "\r\n");
            ds.writeBytes("\r\n");
            InputStream inputStream = conn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, code);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            res = sb.toString();
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return res;
    }

    private String getContentType(File f) throws Exception {
        ImageInputStream imagein = ImageIO.createImageInputStream(f);
        if (imagein == null) {
            return "application/octet-stream";
        }
        Iterator<ImageReader> it = ImageIO.getImageReaders(imagein);
        if (!it.hasNext()) {
            imagein.close();
            return "application/octet-stream";
        }
        imagein.close();
        return "image/" + it.next().getFormatName().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postBody(String url, String body) {
        long start = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        String res = null;
        try {
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setConnectTimeout(1000);
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.getOutputStream().write(body.getBytes("UTF-8"));
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
            InputStream in = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = bufferedReader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                builder.append(line);
                line = bufferedReader.readLine();
            }
            res = builder.toString();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return res;
    }

    @Override
    public String postFile(String url, Map<String, ?> params, List<Pair<String, File>> files, String code) {
        return null;
    }
}

