/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.http;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import jmind.base.lang.Pair;
import jmind.base.util.DataUtil;
import jmind.core.http.HttpClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClient4
extends HttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String url, final String code, int soTimeout) {
        CloseableHttpClient httpclient;
        long start = System.currentTimeMillis();
        String res = null;
        if (soTimeout > 0) {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(soTimeout).setSocketTimeout(soTimeout).build();
            httpclient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
        } else {
            httpclient = HttpClients.createDefault();
        }
        try {
            HttpGet httpget = new HttpGet(url);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)code) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            res = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            httpget.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, Cookie[] cookies) {
        long start = System.currentTimeMillis();
        StringBuilder c = new StringBuilder();
        for (Cookie cookie : cookies) {
            c.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
        }
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0"));
        defaultHeaders.add(new BasicHeader("Cookie", c.toString()));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultHeaders(defaultHeaders).build();
        String res = null;
        try {
            HttpGet httpget = new HttpGet(url);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            res = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            httpget.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(String url, String code, int timeout, List<NameValuePair> params) {
        CloseableHttpClient httpclient;
        long start = System.currentTimeMillis();
        if (timeout > 0) {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            httpclient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
        } else {
            httpclient = HttpClients.createDefault();
        }
        String res = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (params != null) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, code));
            }
            response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity2 = response.getEntity();
            res = EntityUtils.toString((HttpEntity)entity2, (String)code);
            EntityUtils.consume((HttpEntity)entity2);
            httpPost.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    @Override
    public String post(String url, Map<String, ?> params, String code, int timeout) {
        ArrayList<NameValuePair> nvps = null;
        if (!DataUtil.isEmpty(params)) {
            nvps = new ArrayList<NameValuePair>();
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                nvps.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
        }
        return this.post(url, code, timeout, nvps);
    }

    @Override
    public String post(String url, List<Pair<String, String>> params, String code, int timeout) {
        ArrayList<NameValuePair> nvps = null;
        if (!DataUtil.isEmpty(params)) {
            nvps = new ArrayList<NameValuePair>();
            for (Pair<String, String> entry : params) {
                nvps.add((NameValuePair)new BasicNameValuePair((String)entry.getFirst(), (String)entry.getSecond()));
            }
        }
        return this.post(url, code, timeout, nvps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postFile(String url, Map<String, ?> params, String fileName, File file, String code) {
        Charset charset = DataUtil.isEmpty((String)code) ? Charset.defaultCharset() : Charset.forName(code);
        long start = System.currentTimeMillis();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String res = null;
        try {
            HttpPost httppost = new HttpPost(url);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(charset);
            multipartEntityBuilder.addBinaryBody(fileName, file);
            if (!DataUtil.isEmpty(params)) {
                ContentType contentType = ContentType.create((String)"text/plain", (Charset)charset);
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
                }
            }
            httppost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                res = EntityUtils.toString((HttpEntity)resEntity, (Charset)charset);
            }
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postFile(String url, Map<String, ?> params, List<Pair<String, File>> files, String code) {
        Charset charset = DataUtil.isEmpty((String)code) ? Charset.defaultCharset() : Charset.forName(code);
        long start = System.currentTimeMillis();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String res = null;
        try {
            HttpPost httppost = new HttpPost(url);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(charset);
            for (Pair<String, File> pair : files) {
                multipartEntityBuilder.addBinaryBody((String)pair.getFirst(), (File)pair.getSecond());
            }
            if (!DataUtil.isEmpty(params)) {
                ContentType contentType = ContentType.create((String)"text/plain", (Charset)charset);
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
                }
            }
            httppost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                res = EntityUtils.toString((HttpEntity)httpEntity, (Charset)charset);
            }
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postBody(String url, String body) {
        long start = System.currentTimeMillis();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String res = null;
        try {
            CloseableHttpResponse response;
            HttpEntity resEntity;
            HttpPost httppost = new HttpPost(url);
            if (!DataUtil.isEmpty((String)body)) {
                httppost.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            if ((resEntity = (response = httpclient.execute((HttpUriRequest)httppost)).getEntity()) != null) {
                res = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }
}

