/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.geo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.net.URLEncoder;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jmind.base.util.DataUtil;
import jmind.core.geo.GLocation;
import jmind.core.geo.Geo;
import jmind.core.support.HttpUtil;

public class SoGouGeo
implements Geo {
    public static void main(String[] args) {
        SoGouGeo geo = new SoGouGeo();
        GLocation address = geo.getByIp();
        System.out.println(address);
    }

    @Override
    public GLocation getByAddress(String address, String city) {
        try {
            String content;
            DBObject jo;
            String status;
            String url = "http://api.go2map.com/engine/api/geocoder/json?addr=" + URLEncoder.encode(address, "UTF-8");
            if (!DataUtil.isEmpty((String)city)) {
                url = url + "&city=" + URLEncoder.encode(city, "UTF-8");
            }
            if ("ok".equals(status = (String)(jo = (DBObject)JSON.parse((String)(content = HttpUtil.get(url)))).get("status"))) {
                BasicDBObject res = (BasicDBObject)jo.get("response");
                GLocation gl = new GLocation();
                gl.setAddress(res.getString("match"));
                gl.setCity(res.getString("city"));
                gl.setProvince(res.getString("province"));
                gl.setX(res.getDouble("x"));
                gl.setY(res.getDouble("y"));
                return gl;
            }
            System.out.println(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GLocation getByCoordinate(String latitude, String longitude) {
        String url = "http://api.go2map.com/engine/api/regeocoder/json?type=1&points=" + longitude + "," + latitude;
        String content = HttpUtil.get(url);
        DBObject jo = (DBObject)JSON.parse((String)content);
        String status = (String)jo.get("status");
        if ("ok".equals(status)) {
            BasicDBList data = (BasicDBList)((BasicDBObject)jo.get("response")).get("data");
            BasicDBObject res = (BasicDBObject)data.get(0);
            GLocation gl = new GLocation();
            gl.setAddress(res.getString("address"));
            gl.setCity(res.getString("city"));
            gl.setProvince(res.getString("province"));
            gl.setDistrict(res.getString("district"));
            return gl;
        }
        System.out.println(content);
        return null;
    }

    public double getDistance(double lat1, double lng1, double lat2, double lng2) {
        String js = HttpUtil.get("http://api.go2map.com/maps/js/api_v2.5.1.js");
        ScriptEngineManager factory = new ScriptEngineManager();
        try {
            ScriptEngine engine = factory.getEngineByName("JavaScript");
            engine.eval(js);
            Invocable invoke = (Invocable)((Object)engine);
            Object object = invoke.invokeFunction("sogou.maps.LatLng", 39.99676822857143, 116.33298485714285);
            System.out.println(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public GLocation getByIp() {
        String url = "http://api.go2map.com/engine/api/ipcity/json?contenttype=utf8";
        String content = HttpUtil.get(url);
        DBObject jo = (DBObject)JSON.parse((String)content);
        String status = (String)jo.get("status");
        if ("ok".equals(status)) {
            BasicDBObject res = (BasicDBObject)jo.get("response");
            GLocation gl = new GLocation();
            gl.setAddress(res.getString("match"));
            gl.setCity(res.getString("city"));
            gl.setProvince(res.getString("province"));
            gl.setX((Number)res.get("x"));
            gl.setY((Number)res.get("y"));
            return gl;
        }
        System.out.println(content);
        return null;
    }
}

