/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.geo;

import java.text.DecimalFormat;
import jmind.base.util.DataUtil;

public class Location2DUtil {
    private double minLon;
    private double minLat;
    private double maxLon;
    private double maxLat;
    private int step;
    private long vitualSize = 10000000000L;
    private static Location2DUtil instance;
    private static final double EARTH_RADIUS = 6371229.0;

    public Location2DUtil(double minLon, double minLat, double maxLon, double maxLat, int step) {
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
        this.step = step;
    }

    public long getLocation1(double lon, double lat) {
        long lonL = (long)((double)this.vitualSize * (lon - this.minLon) / (this.maxLon - this.minLon));
        long latL = (long)((double)this.vitualSize * (lat - this.minLat) / (this.maxLat - this.minLat));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.step; ++i) {
            long s = (long)((double)this.vitualSize / Math.pow(10.0, i + 1));
            sb.append(lonL / s);
            sb.append(latL / s);
            lonL %= s;
            latL %= s;
        }
        return DataUtil.toLong((String)sb.toString());
    }

    public long getLocation2(double lon, double lat) {
        long lonL = (long)((double)this.vitualSize * (lon - this.minLon) / (this.maxLon - this.minLon));
        long latL = (long)((double)this.vitualSize * (lat - this.minLat) / (this.maxLat - this.minLat));
        if ((lonL -= this.vitualSize / 30L) < 0L) {
            lonL += this.vitualSize;
        }
        if ((latL -= this.vitualSize / 30L) < 0L) {
            latL += this.vitualSize;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.step; ++i) {
            long s = (long)((double)this.vitualSize / Math.pow(10.0, i + 1));
            sb.append(lonL / s);
            sb.append(latL / s);
            lonL %= s;
            latL %= s;
        }
        return DataUtil.toLong((String)sb.toString());
    }

    public long getLocation3(double lon, double lat) {
        long lonL = (long)((double)this.vitualSize * (lon - this.minLon) / (this.maxLon - this.minLon));
        long latL = (long)((double)this.vitualSize * (lat - this.minLat) / (this.maxLat - this.minLat));
        if ((lonL -= this.vitualSize / 15L) < 0L) {
            lonL += this.vitualSize;
        }
        if ((latL -= this.vitualSize / 15L) < 0L) {
            latL += this.vitualSize;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.step; ++i) {
            long s = (long)((double)this.vitualSize / Math.pow(10.0, i + 1));
            sb.append(lonL / s);
            sb.append(latL / s);
            lonL %= s;
            latL %= s;
        }
        return DataUtil.toLong((String)sb.toString());
    }

    public long getSameLocation(long locate1, long locate2) {
        DecimalFormat nf = new DecimalFormat("000000000000000000");
        StringBuffer sb = new StringBuffer();
        char[] ch1 = nf.format(locate1).toCharArray();
        char[] ch2 = nf.format(locate2).toCharArray();
        for (int i = 0; i < ch2.length && ch1[i] == ch2[i]; ++i) {
            sb.append(ch1[i]);
        }
        return sb.toString().length();
    }

    public Object[] getLocationArea(double lon1, double lat1, double lon2, double lat2) {
        double lonMax = Math.max(lon1, lon2);
        double latMax = Math.max(lat1, lat2);
        double lonMin = Math.min(lon1, lon2);
        double latMin = Math.min(lat1, lat2);
        long loc1Min = this.getLocation1(lonMin, latMin);
        long loc1Max = this.getLocation1(lonMax, latMax);
        long loc2Min = this.getLocation2(lonMin, latMin);
        long loc2Max = this.getLocation2(lonMax, latMax);
        long loc3Min = this.getLocation3(lonMin, latMin);
        long loc3Max = this.getLocation3(lonMax, latMax);
        long same1 = this.getSameLocation(loc1Min, loc1Max);
        long same2 = this.getSameLocation(loc2Min, loc2Max);
        long same3 = this.getSameLocation(loc3Min, loc3Max);
        if (same1 >= same2 && same1 >= same3) {
            return new Object[]{1, loc1Min, loc1Max};
        }
        if (same2 >= same1 && same2 >= same3) {
            return new Object[]{2, loc2Min, loc2Max};
        }
        return new Object[]{3, loc3Min, loc3Max};
    }

    public static Location2DUtil getDefault() {
        if (instance == null) {
            instance = new Location2DUtil(-180.0, -90.0, 180.0, 90.0, 9);
        }
        return instance;
    }

    public static double getDistanceLon(double lat1, double lon1, double distance) {
        double a = 180.0 * distance / (2.0015806220738243E7 * Math.cos(lat1 * Math.PI / 180.0));
        return a;
    }

    public static double getDistanceLat(double lat1, double lon1, double distance) {
        double a = 180.0 * distance / (2.0015806220738243E7 * Math.cos(lat1 * Math.PI / 180.0));
        return a;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getLocationDistance(double lat1, double lon1, double lat2, double lon2) {
        double radLat1 = Location2DUtil.rad(lat1);
        double radLat2 = Location2DUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = Location2DUtil.rad(lon1) - Location2DUtil.rad(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s *= 6371229.0;
    }

    public static void main(String[] args) {
        System.out.println(Location2DUtil.getLocationDistance(12.131, 12.235, 12.131, 12.123));
        System.out.println(Location2DUtil.getDistanceLon(12.131, 12.123, 12176.1712));
        System.out.println(Location2DUtil.getDistanceLon(12.131, 12.235, 12176.1712));
        System.out.println(Location2DUtil.getLocationDistance(12.131, 12.235, 12.304, 12.235));
        System.out.println(Location2DUtil.getDistanceLat(12.304, 12.235, 19237.413756598322));
        System.out.println(Location2DUtil.getDistanceLat(12.131, 12.235, 19237.413756598322));
    }
}

