/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.geo;

public class Distance {
    private static double EARTH_RADIUS = 6371.229;

    public static void main(String[] args) {
        double x1 = 39.992792;
        double y1 = 116.326142;
        double x2 = 39.99676822857143;
        double y2 = 116.33298485714285;
        System.out.println(Distance.gps2m(x1, y1, x2, y2));
        double calDistance = Distance.getDistance(x1, y1, x2, y2);
        System.out.println(calDistance);
        double distance2 = Distance.distance(x1, y1, x2, y2);
        System.out.println(distance2);
        System.out.println(Distance.distance2(x1, y1, x2, y2));
    }

    public static double gps2m(double lat_a, double lng_a, double lat_b, double lng_b) {
        double radLat1 = lat_a * Math.PI / 180.0;
        double radLat2 = lat_b * Math.PI / 180.0;
        double a = radLat1 - radLat2;
        double b = (lng_a - lng_b) * Math.PI / 180.0;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s = s * EARTH_RADIUS * 1000.0;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = Distance.rad(lat1);
        double radLat2 = Distance.rad(lat2);
        double a = radLat1 - radLat2;
        double b = Distance.rad(lng1) - Distance.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s = s * EARTH_RADIUS * 1000.0;
        return s;
    }

    public static double distance(double lat1, double lat2, double lon1, double lon2) {
        double distance = 0.0;
        double dLat = (lat2 - lat1) * Math.PI / 180.0;
        double dLon = (lon2 - lon1) * Math.PI / 180.0;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1 * Math.PI / 180.0) * Math.cos(lat2 * Math.PI / 180.0) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        distance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)) * EARTH_RADIUS;
        return distance;
    }

    public static double distance2(double n1, double e1, double n2, double e2) {
        double jl_jd = 102834.74258026089;
        double jl_wd = 111712.69150641056;
        double b = Math.abs((e1 - e2) * jl_jd);
        double a = Math.abs((n1 - n2) * jl_wd);
        return Math.sqrt(a * a + b * b);
    }
}

