/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.dubbo.callback;

import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import jmind.core.dubbo.callback.Callback;
import jmind.core.dubbo.callback.ICallbackService;
import jmind.core.dubbo.pojo.BusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackServiceImpl
implements ICallbackService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Multimap<String, Callback> listeners = HashMultimap.create();
    private final BiMap<Callback, String> map = HashBiMap.create();

    @Override
    public void addListener(String key, Callback callback) {
        this.listeners.put((Object)key, (Object)callback);
        String remote = RpcContext.getContext().getRemoteAddressString();
        this.map.put((Object)callback, (Object)(key + remote));
        this.logger.info("addListener key={},remote={}", (Object)key, (Object)remote);
    }

    @Override
    public void addEvent(BusEvent event) {
        this.logger.info("addEvent event={},remote={}", (Object)event, (Object)RpcContext.getContext().getRemoteAddressString());
        Collection collection = this.listeners.get((Object)event.getTopic());
        if (collection.isEmpty()) {
            this.logger.info("event is empty {}", (Object)event);
        } else {
            Iterator it = collection.iterator();
            Callback callback = null;
            while (it.hasNext()) {
                try {
                    callback = (Callback)it.next();
                    boolean b = callback.doIt(event);
                    this.logger.info("doit addEvent {},result={} ", this.map.get((Object)callback), (Object)b);
                }
                catch (RpcException e) {
                    this.logger.error("doit event={},{}", (Object)event, (Object)e);
                    it.remove();
                    this.map.remove((Object)callback);
                }
            }
        }
    }

    @Override
    public Set<String> getRemotes() {
        return this.map.values();
    }
}

