/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.container.Container;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import jmind.base.util.AppEnvironment;
import jmind.core.spring.SpringBeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboServer {
    public static final String CONTAINER_KEY = "dubbo.container";
    public static final String SHUTDOWN_HOOK_KEY = "dubbo.shutdown.hook";
    private static final Logger logger = LoggerFactory.getLogger(DubboServer.class);
    private static volatile boolean running = true;
    private static final ExtensionLoader<Container> loader = ExtensionLoader.getExtensionLoader(Container.class);
    private static SpringBeanFactory context;

    public static SpringBeanFactory getSpringBeanFactory() {
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        context = args != null && args.length > 0 ? new SpringBeanFactory(args) : new SpringBeanFactory("dubbo-server.xml");
        try {
            Object[] configs = Constants.COMMA_SPLIT_PATTERN.split(ConfigUtils.getProperty((String)CONTAINER_KEY, (String)loader.getDefaultExtensionName()));
            final ArrayList<Object> containers = new ArrayList<Object>();
            for (int i = 0; i < configs.length; ++i) {
                containers.add(loader.getExtension(configs[i]));
            }
            System.out.println("Use container type(" + Arrays.toString(configs) + ") to run dubbo serivce. APP_ENV=" + AppEnvironment.getEnvironment());
            if ("true".equals(System.getProperty(SHUTDOWN_HOOK_KEY))) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        Iterator iterator = containers.iterator();
                        while (iterator.hasNext()) {
                            Container container = (Container)iterator.next();
                            try {
                                container.stop();
                                logger.info("Dubbo " + container.getClass().getSimpleName() + " stopped!");
                            }
                            catch (Throwable t) {
                                logger.error(t.getMessage(), t);
                            }
                            Class<DubboServer> clazz = DubboServer.class;
                            // MONITORENTER : jmind.core.dubbo.DubboServer.class
                            running = false;
                            DubboServer.class.notify();
                            // MONITOREXIT : clazz
                        }
                    }
                });
            }
            for (Container container : containers) {
                container.start();
                logger.info("Dubbo " + container.getClass().getSimpleName() + " started!");
            }
            System.out.println(new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss]").format(new Date()) + " Dubbo service server started!");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        Class<DubboServer> clazz = DubboServer.class;
        synchronized (DubboServer.class) {
            while (running) {
                try {
                    DubboServer.class.wait();
                }
                catch (Throwable throwable) {}
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

