/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.captcha;

import com.google.code.kaptcha.text.TextProducer;
import com.google.code.kaptcha.util.Config;
import com.google.code.kaptcha.util.Configurable;
import java.util.Properties;
import java.util.Random;
import jmind.base.util.RandUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseTextCreator
extends Configurable
implements TextProducer {
    private static final Logger log = LoggerFactory.getLogger(ChineseTextCreator.class);
    private final String outputEncode = "UTF-8";
    private static String[] kaptchaIdioms = null;

    public String getText() {
        try {
            String result = kaptchaIdioms[RandUtil.nextInt((int)kaptchaIdioms.length)].trim();
            while (StringUtils.isBlank((String)result) || result.length() != 4) {
                result = kaptchaIdioms[RandUtil.nextInt((int)kaptchaIdioms.length)].trim();
            }
            return result;
        }
        catch (Exception e) {
            log.error("generate random idiom error, so, generate four random chinese character", (Throwable)e);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 4; ++i) {
                sb.append(this.getChineseCharacter(RandUtil.getRandom()));
            }
            return sb.toString();
        }
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        if (kaptchaIdioms == null || kaptchaIdioms.length == 0) {
            Properties properties = new Properties();
            try {
                properties.load(ChineseTextCreator.class.getClassLoader().getResourceAsStream("kaptcha-idiom.properties"));
                String idioms = properties.getProperty("dictionary");
                kaptchaIdioms = idioms.split(",");
            }
            catch (Exception e) {
                log.error("kaptcha init error", (Throwable)e);
            }
        }
    }

    private String getChineseCharacter(Random random) {
        byte high = new Integer(176 + Math.abs(random.nextInt(39))).byteValue();
        byte low = new Integer(161 + Math.abs(random.nextInt(93))).byteValue();
        byte[] bytes = new byte[]{high, low};
        String result = "\u9519";
        try {
            result = new String(new String(bytes, "GB2312").getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception e) {
            log.warn("GB2312 or UTF-8 not supported!", (Throwable)e);
        }
        return result;
    }
}

