/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.xmemcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.KestrelCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.ElectionMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.LibmemcachedMemcachedSessionLocator;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.TokyoTyrantTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.transcoders.WhalinTranscoder;
import net.rubyeye.xmemcached.transcoders.WhalinV1Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;

public class MemcachedBuilder {
    private static final String MEMCACHED_PROFIX = "memcached.";
    private static final String HOSTS = "hosts";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SESSION_LOCATOR = "shard.hashingAlgorithm";
    private static final String COMMAND_FACTORY = "useBinaryCommand";
    private static final String POOL_SIZE = "pool.size";
    private static final String POOL_FAILURE_MODE = "pool.failureMode";
    private static final String TRANSCODER = "transcoder";
    private static final String TRANSCODER_COMPRESSION_THRESHOLD = "transcoder.compressionThreshold";
    private static final String TRANSCODER_PACK_ZEROS = "transcoder.packZeros";
    private static final String TRANSCODER_PRIMITIVE_AS_STRING = "primitiveAsString";
    private static final String SANITIZE_KEYS = "sanitizeKeys";
    private static final String JMX_ENABLE = "jmx.enable";
    private static final String JMX_RMI_PORT = "jmx.rmiPort";
    private static final String JMX_RMI_NAME = "jmx.rmiName";
    private MemcachedClient clientDelegate;
    private final IProperties prop;
    private final String name;

    public MemcachedBuilder(IProperties properties, String name) {
        this.prop = properties;
        this.name = name + ".";
        if (Boolean.parseBoolean(this.getProperty("simple", "true"))) {
            this.initDefault();
        } else {
            this.initClient();
        }
    }

    public final MemcachedClient client() {
        return this.clientDelegate;
    }

    private void initDefault() {
        String hosts = this.getProperty(HOSTS, "127.0.0.1:11211");
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)hosts));
        builder.setConnectionPoolSize(DataUtil.toInt((String)this.getProperty(POOL_SIZE, "1")));
        builder.setOpTimeout(Long.parseLong(this.getProperty("timeout", "5000")));
        System.out.println(this.name + " init mem hosts=" + hosts + ",poolsize=" + this.getProperty(POOL_SIZE, "1"));
        try {
            this.clientDelegate = builder.build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initClient() {
        this.initJmx();
        MemcachedClientBuilder builder = this.initBuilder();
        builder.setCommandFactory(this.parseCommandFactory());
        builder.setConnectionPoolSize(Integer.parseInt(this.getProperty(POOL_SIZE, "5")));
        builder.setOpTimeout(Long.parseLong(this.getProperty("timeout", "5000")));
        builder.setFailureMode(Boolean.parseBoolean(this.getProperty(POOL_FAILURE_MODE, "false")));
        builder.setSessionLocator(this.parseSessionLoactor());
        builder.getConfiguration().setSoTimeout(5000);
        builder.setTranscoder(this.parseTranscoder());
        builder.getTranscoder().setCompressionThreshold(Integer.parseInt(this.getProperty(TRANSCODER_COMPRESSION_THRESHOLD, "16384")));
        builder.getTranscoder().setPackZeros(Boolean.parseBoolean(this.getProperty(TRANSCODER_PACK_ZEROS, "true")));
        builder.getTranscoder().setPrimitiveAsString(Boolean.parseBoolean(this.getProperty(TRANSCODER_PRIMITIVE_AS_STRING, "false")));
        try {
            this.clientDelegate = builder.build();
            this.clientDelegate.setSanitizeKeys(Boolean.parseBoolean(this.getProperty(SANITIZE_KEYS, "false")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getProperty(String key, String defaultVal) {
        return this.prop.getProperty(MEMCACHED_PROFIX + this.name + key, defaultVal);
    }

    private void initJmx() {
        Boolean enable = Boolean.parseBoolean(this.getProperty(JMX_ENABLE, "false"));
        Integer rmiPort = Integer.parseInt(this.getProperty(JMX_RMI_PORT, "10001"));
        String rmiName = this.getProperty(JMX_RMI_NAME, "memcached");
        if (enable.booleanValue()) {
            System.setProperty("xmemcached.jmx.enable", enable.toString());
        }
        System.setProperty("xmemcached.rmi.port", rmiPort.toString());
        System.setProperty("xmemcached.rmi.name", rmiName);
    }

    private MemcachedClientBuilder initBuilder() {
        String hosts = this.getProperty(HOSTS, "127.0.0.1:11211");
        System.out.println(this.name + " init mem hosts=" + hosts);
        Map<InetSocketAddress, InetSocketAddress> addressMap = this.parseAddress(hosts);
        int[] weights = this.parseHostWeights(hosts, addressMap.size());
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(addressMap, weights);
        String username = this.getProperty(USERNAME, null);
        String password = this.getProperty(PASSWORD, null);
        if (username != null && username.trim().length() > 0 && password != null && password.trim().length() > 0) {
            for (InetSocketAddress address : addressMap.keySet()) {
                AuthInfo authInfo = AuthInfo.typical((String)username, (String)password);
                builder.addAuthInfo(address, authInfo);
            }
        }
        return builder;
    }

    private MemcachedSessionLocator parseSessionLoactor() {
        String sessionLocatorName = this.getProperty(SESSION_LOCATOR, "KETAMA").toUpperCase();
        if ("KETAMA".equals(sessionLocatorName)) {
            return new KetamaMemcachedSessionLocator();
        }
        if ("MEMCACHED".equals(sessionLocatorName)) {
            return new LibmemcachedMemcachedSessionLocator();
        }
        if ("ELECTION".equals(sessionLocatorName)) {
            return new ElectionMemcachedSessionLocator();
        }
        return new ArrayMemcachedSessionLocator();
    }

    private CommandFactory parseCommandFactory() {
        String commandFactoryName;
        Boolean useBinaryCommand = Boolean.parseBoolean(this.getProperty(COMMAND_FACTORY, "false"));
        String string = commandFactoryName = useBinaryCommand != false ? "BINARY" : "TEXT";
        if ("BINARY".equals(commandFactoryName)) {
            return new BinaryCommandFactory();
        }
        if ("TEXT".equals(commandFactoryName)) {
            return new TextCommandFactory();
        }
        if ("KESTREL".equals(commandFactoryName)) {
            return new KestrelCommandFactory();
        }
        return null;
    }

    private Transcoder<?> parseTranscoder() {
        String sessionLocatorName = this.getProperty(TRANSCODER, "SERIALIZING").toUpperCase();
        if ("SERIALIZING".equals(sessionLocatorName)) {
            return new SerializingTranscoder();
        }
        if ("TT".equals(sessionLocatorName)) {
            return new TokyoTyrantTranscoder();
        }
        if ("WHALIN".equals(sessionLocatorName)) {
            return new WhalinTranscoder();
        }
        if ("WHALIN_V1".equals(sessionLocatorName)) {
            return new WhalinV1Transcoder();
        }
        return null;
    }

    public final void destory() {
        if (this.clientDelegate != null && !this.clientDelegate.isShutdown()) {
            try {
                this.client().shutdown();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.clientDelegate = null;
        }
    }

    private Map<InetSocketAddress, InetSocketAddress> parseAddress(String hosts) {
        String hostsWithoutWeights = hosts.replaceAll("\\*\\d+", "");
        List addressList = AddrUtil.getAddresses((String)hostsWithoutWeights);
        LinkedHashMap<InetSocketAddress, InetSocketAddress> addressMap = new LinkedHashMap<InetSocketAddress, InetSocketAddress>();
        if (addressList != null) {
            for (InetSocketAddress addr : addressList) {
                addressMap.put(addr, null);
            }
        }
        return addressMap;
    }

    private int[] parseHostWeights(String hosts, int expectedSize) {
        ArrayList<Integer> weighList = new ArrayList<Integer>();
        String regex = "\\*(\\d+)";
        Pattern pattern = Pattern.compile("\\*(\\d+)");
        Matcher matcher = pattern.matcher(hosts);
        while (matcher.find()) {
            weighList.add(Integer.parseInt(matcher.group(1)));
        }
        Integer[] weights = expectedSize == weighList.size() ? weighList.toArray(new Integer[weighList.size()]) : null;
        return MemcachedBuilder.toPrimitive(weights);
    }

    private static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new int[0];
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }
}

