/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import jmind.base.lang.ExpireRecord;
import jmind.core.cache.support.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMemCache
implements Counter<String, Object> {
    private final MemcachedClient cache;
    private final int expSecond;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public final ExpireRecord RECORD = new ExpireRecord(300);

    public XMemCache(MemcachedClient cache) {
        this(cache, 604800);
    }

    public XMemCache(MemcachedClient cache, int expSecond) {
        this.cache = cache;
        this.expSecond = expSecond;
    }

    private final void err(String key, Exception e) {
        this.logger.error("get key=" + key, (Throwable)e);
        this.RECORD.ExceptionRecord(e, new Object[0]);
    }

    public boolean set(String key, Object value) {
        try {
            if (value != null) {
                return this.cache.set(key, this.expSecond, value);
            }
        }
        catch (Exception e) {
            this.logger.error("set key=" + key, (Throwable)e);
        }
        return false;
    }

    public boolean set(String key, int seconds, Object value) {
        try {
            if (value != null) {
                return this.cache.set(key, seconds, value);
            }
        }
        catch (Exception e) {
            this.logger.error("set key=" + key, (Throwable)e);
        }
        return false;
    }

    public boolean delete(String key) {
        try {
            return this.cache.delete(key);
        }
        catch (Exception e) {
            this.logger.error("delete key=" + key, (Throwable)e);
            return false;
        }
    }

    public Object get(String key) {
        try {
            return this.cache.get(key);
        }
        catch (Exception e) {
            this.err(key, e);
            return null;
        }
    }

    public Map<String, Object> getMulti(Collection<String> keys) {
        LinkedHashMap maps = Maps.newLinkedHashMap();
        try {
            Map gets = this.cache.gets(keys);
            for (Map.Entry entry : gets.entrySet()) {
                maps.put(entry.getKey(), ((GetsResponse)entry.getValue()).getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("getMulti", (Throwable)e);
        }
        return maps;
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
    }

    @Override
    public int getAndInc(String key) {
        return this.inc(key, 1) - 1;
    }

    @Override
    public int incAndGet(String key) {
        return this.inc(key, 1);
    }

    @Override
    public int inc(String key, int vaule) {
        try {
            return (int)this.cache.incr(key, (long)vaule, (long)vaule);
        }
        catch (Exception e) {
            this.logger.error("inc key=" + key, (Throwable)e);
            return 0;
        }
    }

    @Override
    public int decrAndGet(String key) {
        return this.decr(key, 1);
    }

    @Override
    public int getAndDecr(String key) {
        return this.decr(key, 1) + 1;
    }

    @Override
    public int decr(String key, int value) {
        try {
            return (int)this.cache.decr(key, (long)value, (long)value);
        }
        catch (Exception e) {
            this.logger.error("decr key=" + key, (Throwable)e);
            return 0;
        }
    }

    public boolean exists(String key) {
        return this.get(key) != null;
    }
}

