/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jmind.core.cache.support.Counter;

public class LocalCounter<K>
implements Counter<K, Integer> {
    private final Cache<K, AtomicInteger> cache;

    public LocalCounter(int maxSize, int duration, boolean access) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues();
        this.cache = access ? builder.expireAfterAccess((long)duration, TimeUnit.MINUTES).build() : builder.expireAfterWrite((long)duration, TimeUnit.MINUTES).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicInteger mustGet(K key) {
        AtomicInteger value = (AtomicInteger)this.cache.getIfPresent(key);
        if (value == null) {
            Cache<K, AtomicInteger> cache = this.cache;
            synchronized (cache) {
                value = (AtomicInteger)this.cache.getIfPresent(key);
                if (value == null) {
                    value = new AtomicInteger();
                    this.cache.put(key, (Object)value);
                }
            }
        }
        return value;
    }

    public boolean set(K key, Integer value) {
        this.cache.put(key, (Object)new AtomicInteger(value));
        return true;
    }

    public boolean delete(K key) {
        if (this.cache.getIfPresent(key) != null) {
            this.cache.invalidate(key);
            return true;
        }
        return false;
    }

    public Integer get(K key) {
        AtomicInteger integer = (AtomicInteger)this.cache.getIfPresent(key);
        return integer == null ? 0 : integer.get();
    }

    public Map<K, Integer> getMulti(Collection<K> keys) {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (K key : keys) {
            Object value = this.get((Object)key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public int getAndInc(K key) {
        return this.mustGet(key).getAndIncrement();
    }

    @Override
    public int incAndGet(K key) {
        return this.mustGet(key).incrementAndGet();
    }

    @Override
    public int decrAndGet(K key) {
        return this.mustGet(key).decrementAndGet();
    }

    @Override
    public int getAndDecr(K key) {
        return this.mustGet(key).getAndDecrement();
    }

    @Override
    public int decr(K key, int val) {
        return this.mustGet(key).addAndGet(-val);
    }

    @Override
    public int inc(K key, int val) {
        return this.mustGet(key).addAndGet(val);
    }

    public boolean set(K key, int seconds, Integer value) {
        this.set(key, value);
        return true;
    }

    public boolean exists(K key) {
        return this.cache.getIfPresent(key) != null;
    }
}

