/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jmind.base.cache.MemCache;

public class GuavaCache<K, V>
implements MemCache<K, V> {
    final Cache<K, V> cache;

    public GuavaCache() {
        this(3000);
    }

    public GuavaCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues().build();
    }

    public GuavaCache(int maxSize, int duration) {
        this(maxSize, duration, false);
    }

    public GuavaCache(int maxSize, int duration, boolean access) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues();
        this.cache = access ? builder.expireAfterAccess((long)duration, TimeUnit.MINUTES).build() : builder.expireAfterWrite((long)duration, TimeUnit.MINUTES).build();
    }

    public boolean set(K key, V value) {
        if (key != null && value != null) {
            this.cache.put(key, value);
        }
        return true;
    }

    public boolean set(K key, int seconds, V value) {
        this.set(key, value);
        return true;
    }

    public boolean delete(K key) {
        if (this.cache.getIfPresent(key) != null) {
            this.cache.invalidate(key);
        }
        return true;
    }

    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    public Map<K, V> getMulti(Collection<K> keys) {
        return this.cache.getAllPresent(keys);
    }

    public String toString() {
        return this.cache.asMap().toString();
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public boolean exists(K key) {
        return this.cache.getIfPresent(key) != null;
    }
}

