/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jmind.base.cache.ConcurrentLRUCache;
import jmind.base.cache.MemCache;
import jmind.core.cache.support.GuavaCache;
import jmind.core.manager.XMemCacheManager;

public class Cache {
    private final MemCache<String, Object> guava = new GuavaCache<String, Object>(6000, 10, false);
    private final ConcurrentLRUCache<String, Object> PersistentCache = new ConcurrentLRUCache(new ConcurrentHashMap());

    private Cache() {
    }

    public static Cache getCache() {
        return Nested.instance;
    }

    public MemCache<String, Object> getCache(MemCache.Type type, String name) {
        switch (type) {
            case XMEM: {
                return (MemCache)XMemCacheManager.getInstance().getResource(name);
            }
            case GUAVA: {
                return this.guava;
            }
            case PERSISTENT: {
                return this.PersistentCache;
            }
        }
        return this.guava;
    }

    public Map<String, Object> stats(MemCache cache) {
        HashMap map = Maps.newHashMap();
        Object obj = cache.getCache();
        if (obj instanceof com.google.common.cache.Cache) {
            com.google.common.cache.Cache c = (com.google.common.cache.Cache)obj;
            map.put("size", c.size());
            map.put("stats", c.stats());
        } else if (obj instanceof Map) {
            Map c = (Map)obj;
            map.put("size", c.size());
        }
        return map;
    }

    static class Nested {
        private static Cache instance = new Cache();

        Nested() {
        }
    }
}

