/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.aspect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import jmind.base.util.DataUtil;
import jmind.core.annotation.CacheMonitor;
import jmind.core.cache.support.XMemCache;
import jmind.core.geo.GLocation;
import jmind.core.manager.XMemCacheManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class CacheSpELAspect {
    final ExpressionParser parser = new SpelExpressionParser();
    final ConcurrentMap<String, List<Expression>> expressionMap = Maps.newConcurrentMap();

    @Pointcut(value="@annotation(jmind.core.annotation.CacheMonitor)")
    public void exe2() {
    }

    @Around(value="exe2()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.doit(pjp);
    }

    private List<Expression> getExpressions(String spel) {
        List list = (List)this.expressionMap.get(spel);
        if (list == null) {
            list = Lists.newArrayList();
            StringTokenizer token = new StringTokenizer(spel, ",");
            while (token.hasMoreTokens()) {
                list.add(this.parser.parseExpression(token.nextToken()));
            }
            this.expressionMap.put(spel, list);
        }
        return list;
    }

    private Object doit(ProceedingJoinPoint pjp) throws Throwable {
        String key;
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        CacheMonitor m = signature.getMethod().getAnnotation(CacheMonitor.class);
        if (m.spel().isEmpty()) {
            key = DataUtil.composeKey((String)m.prefix(), (Object[])pjp.getArgs());
        } else {
            StandardEvaluationContext context = new StandardEvaluationContext();
            String[] names = signature.getParameterNames();
            Object[] values = pjp.getArgs();
            for (int i = 0; i < names.length; ++i) {
                context.setVariable(names[i], values[i]);
            }
            StringBuilder sb = new StringBuilder(m.prefix());
            List<Expression> expressions = this.getExpressions(m.spel());
            for (Expression exp : expressions) {
                sb.append("_").append(exp.getValue((EvaluationContext)context));
            }
            key = sb.toString();
        }
        XMemCache cache = (XMemCache)XMemCacheManager.getInstance().getResource(m.name());
        if (m.remove()) {
            cache.delete(key);
            return pjp.proceed();
        }
        Object obj = cache.get(key);
        if (obj == null && (obj = pjp.proceed()) != null) {
            cache.set(key, m.exp(), obj);
        }
        return obj;
    }

    public static void expression() {
        SpelExpressionParser parser = new SpelExpressionParser();
        GLocation root = new GLocation();
        root.setCity("\u6e56\u5357");
        root.setX(101);
        GLocation user = new GLocation();
        user.setCity("beijing");
        user.setX(12);
        StandardEvaluationContext context = new StandardEvaluationContext((Object)root);
        context.setVariable("userId", (Object)101);
        context.setVariable("user", (Object)user);
        Object value = parser.parseExpression("#userId + 'findById'").getValue((EvaluationContext)context);
        System.out.println(value);
        value = parser.parseExpression("#user.city").getValue((EvaluationContext)context);
        System.out.println(value);
        String result1 = (String)parser.parseExpression("#root.city").getValue((EvaluationContext)context, String.class);
        System.out.println(result1);
        Object result = parser.parseExpression("#this").getValue((EvaluationContext)context);
        System.out.println(result);
    }

    public static void main(String[] args) {
        String[] a;
        String s = "abc";
        long t = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        StringTokenizer token = new StringTokenizer(s, ",");
        while (token.hasMoreTokens()) {
            sb.append(token.nextToken());
        }
        System.out.println(System.currentTimeMillis() - t);
        System.out.println(sb);
        t = System.currentTimeMillis();
        sb = new StringBuilder();
        for (String aa : a = s.split(",")) {
            sb.append(aa);
        }
        System.out.println(System.currentTimeMillis() - t);
        System.out.println(sb);
    }
}

