/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.aspect;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmind.base.cache.MemCache;
import jmind.base.util.DataUtil;
import jmind.core.annotation.CacheMonitor;
import jmind.core.aspect.JoinPoints;
import jmind.core.cache.support.Cache;
import jmind.core.manager.RedisManager;
import jmind.core.redis.Redis;
import jmind.core.support.MethodSupport;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CacheAspect {
    public static Map<ProceedingJoinPoint, Class> MS = Maps.newConcurrentMap();
    public static Map<Method, Class> M = Maps.newConcurrentMap();

    @Pointcut(value="@annotation(jmind.core.annotation.CacheMonitor)")
    public void exe2() {
    }

    @Around(value="exe2()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.doit(pjp);
    }

    private Object doit(ProceedingJoinPoint pjp) throws Throwable {
        String key;
        CacheMonitor m = JoinPoints.getAnnotation(pjp, CacheMonitor.class);
        String string = key = m.spel().isEmpty() ? DataUtil.composeKey((String)m.prefix(), (Object[])pjp.getArgs()) : m.prefix() + "_" + MethodSupport.getProperty(pjp.getArgs()[0], m.spel());
        if (m.type() == MemCache.Type.REDIS) {
            return this.doRedis(pjp, m, key);
        }
        MemCache<String, Object> cache = Cache.getCache().getCache(m.type(), m.name());
        if (m.remove()) {
            Object object = pjp.proceed();
            cache.delete((Object)key);
            return object;
        }
        return cache.computeIfAbsent((Object)key, m.exp(), k -> {
            try {
                return pjp.proceed();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        });
    }

    private final Object doRedis(ProceedingJoinPoint pjp, CacheMonitor m, String key) throws Throwable {
        Redis cache = (Redis)RedisManager.getInstance().getResource(m.name());
        if (m.remove()) {
            Object object = pjp.proceed();
            cache.del(key);
            return object;
        }
        String obj = cache.get(key);
        if (obj == null) {
            Object ob = pjp.proceed();
            if (ob != null) {
                cache.setex(key, m.exp(), JSON.toJSONString((Object)ob));
            }
            return ob;
        }
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Class returnType = signature.getReturnType();
        MS.put(pjp, returnType);
        if (returnType.equals(String.class)) {
            return obj;
        }
        if (List.class.isAssignableFrom(returnType)) {
            List list = JSON.parseArray((String)obj, (Class)this.getRawType(signature, returnType));
            if (!returnType.isInterface() && !returnType.isInstance(list)) {
                List o = (List)returnType.newInstance();
                o.addAll(list);
                return o;
            }
            return list;
        }
        if (Set.class.isAssignableFrom(returnType)) {
            List list = JSON.parseArray((String)obj, (Class)this.getRawType(signature, returnType));
            if (returnType.isInterface()) {
                return new HashSet(list);
            }
            Set set = (Set)returnType.newInstance();
            set.addAll(list);
            return set;
        }
        if (Map.class.isAssignableFrom(returnType)) {
            Map map = (Map)JSON.parseObject((String)obj, Map.class);
            Class aClass = this.getRawType(signature, returnType, 1);
            if (!map.isEmpty() && map.values().iterator().next().getClass() != aClass) {
                Map mm = this.newMap(aClass);
                map.forEach((k, v) -> mm.put((String)k, (Object)JSON.parseObject((String)v.toString(), (Class)aClass)));
                return mm;
            }
            return map;
        }
        return JSON.parseObject((String)obj, (Class)signature.getReturnType());
    }

    private final <T> Map<String, T> newMap(Class<T> clazz) {
        return new HashMap();
    }

    private final Class getRawType(MethodSignature signature, Class returnType, int index) {
        return M.computeIfAbsent(signature.getMethod(), m -> {
            Type type = m.getGenericReturnType();
            TypeToken type2 = TypeToken.of((Type)type).resolveType(returnType.getTypeParameters()[index]);
            return type2.getRawType();
        });
    }

    private final Class getRawType(MethodSignature signature, Class returnType) {
        return this.getRawType(signature, returnType, 0);
    }
}

