/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmind.base.cache.MemCache;
import jmind.core.annotation.CacheMonitor;
import jmind.core.ip.Location;
import jmind.core.spring.SpringBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class TestCache {
    public static void main(String[] args) {
        TestCache bean = (TestCache)SpringBeanFactory.getInstance().getBean(TestCache.class);
        for (int i = 0; i < 3; ++i) {
            bean.getMap("as", "bd").values().forEach(a -> System.out.println(a + "----" + a.getClass()));
        }
    }

    @CacheMonitor(prefix="s", type=MemCache.Type.REDIS)
    public String getStr(String a, String b) {
        return a + b;
    }

    @CacheMonitor(prefix="int", type=MemCache.Type.REDIS)
    public int getInt(String a, String b) {
        return 101;
    }

    @CacheMonitor(prefix="list", type=MemCache.Type.REDIS)
    public LinkedList<Location> getList(String a, String b) {
        LinkedList list = Lists.newLinkedList();
        for (int i = 0; i < 2; ++i) {
            Location location = new Location();
            location.setCity(a);
            location.setAddress(b);
            location.setA(113);
            location.setB(new Date());
            list.add(location);
        }
        return list;
    }

    @CacheMonitor(prefix="list2", type=MemCache.Type.REDIS)
    public List<Location> getList2(String a, String b) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 2; ++i) {
            Location location = new Location();
            location.setCity(a);
            location.setAddress(b);
            location.setA(103);
            location.setB(new Date());
            list.add(location);
        }
        return list;
    }

    @CacheMonitor(prefix="set", type=MemCache.Type.REDIS)
    public Set<Location> getSet(String a, String b) {
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < 2; ++i) {
            Location location = new Location();
            location.setCity(a);
            location.setAddress(b + "sss" + i);
            location.setA(101);
            location.setB(new Date());
            set.add(location);
        }
        return set;
    }

    @CacheMonitor(prefix="map--", type=MemCache.Type.REDIS)
    public Map<String, Object> getMap2(String a, String b) {
        HashMap map = Maps.newHashMap();
        map.put("a", a);
        map.put("b", b);
        return map;
    }

    @CacheMonitor(prefix="map", type=MemCache.Type.REDIS)
    public Map<String, Location> getMap(String a, String b) {
        HashMap map = Maps.newHashMap();
        Location location = new Location();
        location.setCity(a);
        location.setAddress(b);
        location.setA(101);
        location.setB(new Date());
        map.put(a, location);
        return map;
    }
}

