/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.test;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Guava {
    public static void main(String[] args) throws InterruptedException {
        int i;
        HashMap map = Maps.newHashMap();
        Cache cache = CacheBuilder.newBuilder().maximumSize(12L).softValues().build();
        cache.put((Object)"abcde", (Object)"fedgr");
        for (i = 0; i < 10; ++i) {
            cache.put((Object)("ddddddddd" + i), (Object)("cccccc" + i));
        }
        i = 1;
        while (true) {
            map.put("aaaaaaa" + i, "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb" + i);
            System.out.println(cache.size() + "----------" + (String)cache.getIfPresent((Object)"abcde"));
            System.out.println(cache.asMap().keySet().size() + "=" + cache.asMap().values().size());
            System.out.println(cache.asMap());
            Thread.sleep(3000L);
        }
    }

    public void joinTest() {
        ArrayList names = Lists.newArrayList((Object[])new String[]{"John", "Jane", "Adam", "Tom"});
        String result = Joiner.on((String)",").join((Iterable)names);
    }

    public void whenConvertMapToString_thenConverted() {
        HashMap salary = Maps.newHashMap();
        salary.put("John", 1000);
        salary.put("Jane", 1500);
        String result = Joiner.on((String)" , ").withKeyValueSeparator(" = ").join((Map)salary);
        System.out.println(result);
    }

    public void whenConvertListToStringAndSkipNull_thenConverted() {
        ArrayList names = Lists.newArrayList((Object[])new String[]{"John", null, "Jane", "Adam", "Tom"});
        String result = Joiner.on((String)",").skipNulls().join((Iterable)names);
        System.out.println(result);
    }

    public void whenUseForNull_thenUsed() {
        ArrayList names = Lists.newArrayList((Object[])new String[]{"John", null, "Jane", "Adam", "Tom"});
        String result = Joiner.on((String)",").useForNull("nameless").join((Iterable)names);
        System.out.println(result);
    }

    public void whenCreateListFromString_thenCreated() {
        String input = "apple - banana - orange";
        List result = Splitter.on((String)"-").trimResults().splitToList((CharSequence)input);
        System.out.println(result);
    }

    public void whenCreateMapFromString_thenCreated() {
        String input = "John=first,Adam=second";
        Map result = Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)input);
    }

    public void whenSplitStringOnMultipleSeparator_thenSplit() {
        String input = "apple.banana,,orange,,.";
        List result = Splitter.onPattern((String)"[.|,]").omitEmptyStrings().splitToList((CharSequence)input);
        System.out.println(result);
    }

    public void whenSplitStringOnSpecificLength_thenSplit() {
        String input = "Hello world";
        List result = Splitter.fixedLength((int)3).splitToList((CharSequence)input);
        System.out.println(result);
    }

    public void whenLimitSplitting_thenLimited() {
        String input = "a,b,c,d,e";
        List result = Splitter.on((String)",").limit(4).splitToList((CharSequence)input);
        System.out.println(result);
    }
}

