/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.stringMatch.ahocorasick;

import jmind.core.stringMatch.ahocorasick.EdgeList;
import jmind.core.stringMatch.ahocorasick.SparseEdgeList;
import jmind.core.stringMatch.ahocorasick.State;

class DenseEdgeList
implements EdgeList {
    private State[] array = new State[256];

    public DenseEdgeList() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    public static DenseEdgeList fromSparse(SparseEdgeList list) {
        byte[] keys = list.keys();
        DenseEdgeList newInstance = new DenseEdgeList();
        for (int i = 0; i < keys.length; ++i) {
            newInstance.put(keys[i], list.get(keys[i]));
        }
        return newInstance;
    }

    @Override
    public State get(byte b) {
        return this.array[b & 0xFF];
    }

    @Override
    public void put(byte b, State s) {
        this.array[b & 0xFF] = s;
    }

    @Override
    public byte[] keys() {
        int length = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            ++length;
        }
        byte[] result = new byte[length];
        int j = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            result[j] = (byte)i;
            ++j;
        }
        return result;
    }
}

