/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jmind.core.socket.MyRequestObject;

public class ZipMyClient3 {
    private static final Logger logger = Logger.getLogger(ZipMyClient3.class.getName());

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 10) {
            int idx = i++;
            new Thread(new MyRunnable(idx)).start();
        }
    }

    public static void sendData(SocketChannel socketChannel, MyRequestObject myRequestObject) throws IOException {
        Socket socket = socketChannel.socket();
        GZIPOutputStream out = new GZIPOutputStream(socket.getOutputStream());
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(myRequestObject);
        oos.flush();
        out.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyRequestObject receiveData(SocketChannel socketChannel) throws IOException {
        MyRequestObject myRequestObject = null;
        ObjectInputStream ois = null;
        Socket socket = socketChannel.socket();
        try {
            GZIPInputStream gzipis = new GZIPInputStream(socket.getInputStream());
            ois = new ObjectInputStream(gzipis);
            Object obj = ois.readObject();
            myRequestObject = (MyRequestObject)obj;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return myRequestObject;
    }

    private static final class MyRunnable
    implements Runnable {
        private final int idx;

        private MyRunnable(int idx) {
            this.idx = idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketChannel socketChannel = null;
            try {
                socketChannel = SocketChannel.open();
                InetSocketAddress socketAddress = new InetSocketAddress("localhost", 10000);
                socketChannel.connect(socketAddress);
                MyRequestObject myRequestObject = new MyRequestObject("request_" + this.idx, "request_" + this.idx);
                ZipMyClient3.sendData(socketChannel, myRequestObject);
                MyRequestObject myResponseObject = ZipMyClient3.receiveData(socketChannel);
                System.out.println("client receive=" + myResponseObject);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

