/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.socket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmind.base.util.SerializeUtil;
import jmind.core.socket.MyRequestObject;

public class MyClient3 {
    private static final Logger logger = Logger.getLogger(MyClient3.class.getName());

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 10) {
            int idx = i++;
            new Thread(new MyRunnable(idx)).start();
        }
    }

    private static final class MyRunnable
    implements Runnable {
        private final int idx;

        private MyRunnable(int idx) {
            this.idx = idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketChannel socketChannel = null;
            try {
                socketChannel = SocketChannel.open();
                InetSocketAddress socketAddress = new InetSocketAddress("localhost", 10000);
                socketChannel.connect(socketAddress);
                MyRequestObject myRequestObject = new MyRequestObject("request_" + this.idx, "request_" + this.idx);
                this.sendData(socketChannel, myRequestObject);
                MyRequestObject myResponseObject = this.receiveData(socketChannel);
                System.out.println("client receive=" + myResponseObject);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void sendData(SocketChannel socketChannel, MyRequestObject myRequestObject) throws IOException {
            byte[] bytes = SerializeUtil.serialize((Object)myRequestObject);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            socketChannel.write(buffer);
            socketChannel.socket().shutdownOutput();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MyRequestObject receiveData(SocketChannel socketChannel) throws IOException {
            MyRequestObject myResponseObject = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                byte[] bytes;
                ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
                int count = 0;
                while ((count = socketChannel.read(buffer)) >= 0) {
                    buffer.flip();
                    bytes = new byte[count];
                    buffer.get(bytes);
                    baos.write(bytes);
                    buffer.clear();
                }
                bytes = baos.toByteArray();
                Object obj = SerializeUtil.unserialize((byte[])bytes);
                myResponseObject = (MyRequestObject)obj;
            }
            finally {
                try {
                    baos.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return myResponseObject;
        }
    }
}

