/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.util.List;
import java.util.Map;
import jmind.core.jdbc.DatabaseConfig;
import jmind.core.jdbc.JdbcFactory;
import jmind.core.jdbc.TJdbc;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class TDatabase
extends TJdbc {
    private String tableName = ((Object)((Object)this)).getClass().getSimpleName();
    private static DatabaseConfig config;

    public JdbcTemplate getJdbc(int source) {
        String name = config.getDatabase(source);
        return (JdbcTemplate)JdbcFactory.getFactory().getBean(name);
    }

    public static void init(String name) {
        config = new DatabaseConfig(name);
    }

    public String getSql(String key) {
        return config.getSql(this.tableName, key);
    }

    public int update(String key, Object ... args) {
        return super.update(this.getSql(key), args);
    }

    @Override
    public <T> T findOne(int source, String key, Object ... args) {
        return super.findOne(source, this.getSql(key), args);
    }

    @Override
    public <T> List<T> find(int source, String key, Object ... args) {
        return super.find(source, this.getSql(key), args);
    }

    public <T> T findColumValue(int source, String key, Class<T> requiredType, Object ... args) {
        return (T)super.findColumValue(source, this.getSql(key), requiredType, args);
    }

    public int findForInt(int source, String key, Object ... args) {
        return super.findForInt(source, this.getSql(key), args);
    }

    public Map<String, Object> findForMap(int source, String key, Object ... args) {
        return super.findForMap(source, this.getSql(key), args);
    }

    public List<Map<String, Object>> findForList(int source, String key, Object ... args) {
        return super.findForList(source, this.getSql(key), args);
    }
}

