/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import javax.sql.DataSource;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class JdbcFactory {
    private AbstractXmlApplicationContext context = null;
    private static volatile JdbcFactory factory = null;

    public static JdbcFactory getFactory() {
        if (factory == null) {
            factory = new JdbcFactory();
        }
        return factory;
    }

    private JdbcFactory() {
        String path = "jdbc-config.xml";
        this.context = new ClassPathXmlApplicationContext(path);
    }

    public Object getBean(String source) {
        return this.context.getBean(source);
    }

    private DataSource getDataSource(String source) {
        return (DataSource)this.context.getBean(source);
    }

    public JdbcTemplate getJdbc(String source) {
        JdbcTemplate jdbc = new JdbcTemplate(this.getDataSource(source));
        return jdbc;
    }

    public SimpleJdbcInsert getSimpleJdbcInsert(String source) {
        SimpleJdbcInsert jdbc = new SimpleJdbcInsert(this.getDataSource(source));
        return jdbc;
    }

    public NamedParameterJdbcTemplate getNameJdbc(String source) {
        NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate(this.getDataSource(source));
        return jdbc;
    }
}

