/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.concurrent;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SemaphoreTest {
    public static void testPool() {
        final Pool aPool = new Pool(10);
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                String resource = null;
                try {
                    resource = aPool.get();
                    System.out.println("I am working on " + resource);
                    Thread.sleep(500L);
                    System.out.println("I finished on " + resource);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                aPool.put(resource);
            }
        };
        ExecutorService service = Executors.newCachedThreadPool();
        for (int i = 0; i < 5; ++i) {
            service.submit(worker);
        }
        service.shutdown();
    }

    public static void main(String[] args) {
        SemaphoreTest.testPool();
    }

    public static class Pool {
        ArrayList<String> pool = null;
        Semaphore pass = null;
        Lock lock = new ReentrantLock();

        public Pool(int size) {
            this.pool = new ArrayList();
            for (int i = 0; i < size; ++i) {
                this.pool.add("Resource " + i);
            }
            this.pass = new Semaphore(2);
        }

        public String get() throws InterruptedException {
            System.out.println("Try to get a pass...");
            this.pass.acquire();
            System.out.println("Got a pass");
            return this.getResource();
        }

        public void put(String resource) {
            System.out.println("Released a pass");
            this.pass.release();
            this.releaseResource(resource);
        }

        private String getResource() {
            this.lock.lock();
            String result = this.pool.remove(0);
            System.out.println("\u8d44\u6e90 " + result + " \u88ab\u53d6\u8d70");
            this.lock.unlock();
            return result;
        }

        private void releaseResource(String resource) {
            this.lock.lock();
            System.out.println("\u8d44\u6e90 " + resource + " \u88ab\u5f52\u8fd8");
            this.pool.add(resource);
            this.lock.unlock();
        }
    }
}

