/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jmind.core.concurrent.Player;

public class CountDownLatchDemo {
    private static final int PLAYER_AMOUNT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CountDownLatch begin = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(5);
        Player[] plays = new Player[5];
        for (int i = 0; i < 5; ++i) {
            plays[i] = new Player(i + 1, begin, end);
        }
        ExecutorService exe = Executors.newFixedThreadPool(5);
        for (Player p : plays) {
            exe.execute(p);
        }
        System.out.println("Race begins!");
        begin.countDown();
        try {
            end.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("Race ends!");
        }
        exe.shutdown();
    }
}

