package jmind.core.support;

import java.util.regex.Pattern;

import jmind.base.util.DataUtil;

import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public abstract class HTMLUtil {

    private final static Whitelist whiteimg = new Whitelist()
            .addTags("div", "span", "br", "p", "i", "b", "em", "strong", "img").addAttributes("div", "class")
            .addAttributes("span", "class", "name").addAttributes("i", "class").addAttributes("img", "src", "alt")
            .addProtocols("img", "src", "http");
    private final static Whitelist whitelist = new Whitelist().addTags("div", "span", "br", "p", "i", "b", "em", "u",
            "strong", "font");

    private final static Whitelist onlyImg = new Whitelist().addTags("img").addAttributes("img", "src", "border");

    /**
     * 替换掉引号
     * @param body
     * @return
     */
    public static String replaceQuotation(String body) {
        return body.replace("\"", "&#34;").replace("'", "&#39;");
    }

    public static String replaceN(String body) {
        return body.replace("\n", "<br/>");
    }

    public static String relaxed(String body) {
        return Jsoup.clean(body, Whitelist.relaxed());
    }

    public static String basic(String body) {
        return Jsoup.clean(body, Whitelist.basic());
    }

    /**
     * 保留div a,img 等基本标签
     * @param body
     * @return
     */
    public static String clean(String body) {
        return Jsoup.clean(body, whitelist);
    }

    public static String cleanAll(String body) {
        return Jsoup.clean(body, Whitelist.none());
    }

    public static String onlyImg(String body) {
        return Jsoup.clean(body, onlyImg);
    }

    /**
     * 只允许img 标签
     * @param body
     * @return
     */
    public static String baiscWithImg(String body) {
        return Jsoup.clean(body, whiteimg);
    }

    public static String getFlashContent(String flashUrl, int width, int height) {
        //allowScriptAccess='always'
        return "<embed src='" + flashUrl + "' wmode='transparent' quality='high' width='" + width + "' height="
                + height + " align='middle'  type='application/x-shockwave-flash'></embed>";

    }

    public static String decodeHTML(String InputString) {
        String OutputString = null;
        if (InputString == null) {
            return DataUtil.EMPTY;
        } else {
            OutputString = new String(InputString);
            OutputString = OutputString.replace("&lt;", "<");
            OutputString = OutputString.replace("&gt;", ">");
            //	            OutputString = OutputString.replace("&quot;", "\"");
            OutputString = OutputString.replace("\n", "<br/>");
            OutputString = OutputString.replace("&amp;", "&");
            //	            OutputString = OutputString.replace("&#34;", "\"");
            OutputString = OutputString.replace("&#35;", "#");
            //	            OutputString = OutputString.replace("&#39;", "'");
            //	            OutputString = OutputString.replace("&#40;", "(");
            //	            OutputString = OutputString.replace("&#41;", ")");
            return OutputString;
        }
    }

    public static String encodeHTML(String string) {
        if (string == null) {
            return DataUtil.EMPTY;
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        char c;
        for (int i = 0; i < len; i++) {
            c = string.charAt(i);
            switch (c) {
            case '<':
                sb.append("&lt;");
                break;
            case '>':
                sb.append("&gt;");
                break;
            case '&':
                sb.append("&amp;");
                break;
            case '#':
                sb.append("&#35;");
                break;
            //	case ' ': sb.append("&nbsp;");break;
            //	case '(': sb.append("&#40;"); break;
            //	case ')': sb.append("&#41;"); break;
            //	case '"': sb.append("&#34;"); break;
            //	case '\'': sb.append("&#39;"); break; 
            default:
                sb.append(c);
                break;
            }
        }

        return sb.toString();
    }

    private final static String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>"; //定义script的正则表达式{或<script[^>]*?>[\\s\\S]*?<\\/script> }
    private final static String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>"; //定义style的正则表达式{或<style[^>]*?>[\\s\\S]*?<\\/style> }
    private final static String regEx_html = "<[^>]+>"; //定义HTML标签的正则表达式

    public static String Html2Text(String inputString) {
        String htmlStr = inputString; //含html标签的字符串
        String textStr = "";
        java.util.regex.Pattern p_script;
        java.util.regex.Matcher m_script;
        java.util.regex.Pattern p_style;
        java.util.regex.Matcher m_style;
        java.util.regex.Pattern p_html;
        java.util.regex.Matcher m_html;

        try {
            p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE);
            m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll(""); //过滤script标签

            p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
            m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll(""); //过滤style标签

            p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE);
            m_html = p_html.matcher(htmlStr);
            htmlStr = m_html.replaceAll(""); //过滤html标签

            textStr = htmlStr;

        } catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }

        return textStr;//返回文本字符串
    }

    public static void main(String[] args) {
        String content = "sdfd wa$&ve  d%d\njj\n\ndd \"s";
        content = HTMLUtil.cleanAll(content);
        System.out.println(content);
        //        System.out.println(content.replace(" ", "<br>"));
        //        content = HTMLUtil.replaceN(content);
        //        System.out.println(content);

    }

}
