package jmind.core.support;

import java.lang.reflect.InvocationTargetException;
import java.util.*;

import jmind.core.log.LogUtil;
import jmind.base.util.DataUtil;

import org.apache.commons.beanutils.PropertyUtils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.util.NumberUtils;

public class Collections {

    public static <T extends Number> List<T> asList(String str, String separator,Class<T> clazz){
        if (DataUtil.isEmpty(str))
            return java.util.Collections.emptyList();
        List<T> list = new LinkedList<T>();
        asCollection(str,separator,clazz,list);
        return list;
    }

    public static <T extends Number> Set<T> asSet(String str, String separator,Class<T> clazz){
        if (DataUtil.isEmpty(str))
            return java.util.Collections.emptySet();
        Set<T> list = new HashSet<T>();
        asCollection(str,separator,clazz,list);
        return list;
    }

    public static <T extends Number> Collection<T> asCollection(String str, String separator, Class<T> clazz, Collection<T> list) {
        if (separator.length() > 1) {
            String[] split = str.split(separator);
            for (String s : split) {
                s = s.trim();
                if (!s.isEmpty())
                    list.add(NumberUtils.parseNumber(s,clazz));
            }
        } else { // StringTokenizer  长度大于1 ，会对每个字符都匹配
            StringTokenizer token = new StringTokenizer(str, separator);
            while (token.hasMoreTokens()) {
                list.add(NumberUtils.parseNumber(token.nextToken(),clazz));
            }
        }
        return list;
    }



    public static  <T extends Number> List<T> toNumberList(List<String> array,Class<T> clazz) {
        return Lists.transform(array, new Function<String, T>() {
            @Override
            public T apply(String input) {
                return NumberUtils.parseNumber(input,clazz);
            }
        });
    }



    @SuppressWarnings("unchecked")
    public static <T> List<T> getPropertys(Collection<?> list, String name) {
        List<T> a = Lists.newArrayList();
        try {
            for (Object obj : list) {
                //   BeanUtils.getProperty(obj, name);           
                T object = (T) PropertyUtils.getProperty(obj, name);
                a.add(object);
            }
        } catch (Exception e) {
            LogUtil.error(e);
        }
        return a;
    }

    @SuppressWarnings("unchecked")
    public static <A, B> Map<A, B> uniqueIndex(List<B> list, final String name) {
        return Maps.uniqueIndex(list, new Function<B, A>() {
            @Override
            public A apply(B obj) {
                try {
                    return (A) PropertyUtils.getProperty(obj, name);
                } catch (IllegalAccessException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                return null;
            }
        });

    }

}
