package jmind.core.support;

import jmind.base.util.DataUtil;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

/**
 * 条形码查询
 * @author weibo-xie
 * 2012-10-26
 */
public class Barcode {
    public static void main(String[] args) {
        String code = getProductDataByBarCode("6921734976505");
        System.out.println(code);
    }

    public static String getProductDataByBarCode(String barCode) {
        if (DataUtil.isEmpty(barCode))
            return DataUtil.EMPTY;
        try {
            // http://search.anccnet.com/searchResult.aspx?keyword=6907260166061
            String url = "http://ws2.gs1cn.org/anccService.asmx/getProductDataByBarCode";
            Document doc = Jsoup.connect(url).data("clientID", "01d16d4c-6bd1-42ff-904c-bb0e16f5acb7")
                    .data("barcode", barCode).timeout(10000).post();
            //   商品名称
            String name = doc.select("itemname").text();
            if (name.isEmpty()) {
                // 商标名称
                name = doc.select("brandname").text();
            }
            if (name.isEmpty()) {
                //公司名称
                name = doc.select("firmname").text();
            }

            return name;
        } catch (Exception e) {
            e.printStackTrace();
            return DataUtil.EMPTY;
        }
    }

}
