package jmind.core.spring;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class WrapMethodReturnValueHandler implements HandlerMethodReturnValueHandler {

    private HandlerMethodReturnValueHandler delegate;

    public HandlerMethodReturnValueHandler getDelegate() {
        return delegate;
    }

    public void setDelegate(HandlerMethodReturnValueHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return delegate.supportsReturnType(returnType);
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer,
            NativeWebRequest webRequest) throws Exception {
        dohandleReturnValue(returnValue, returnType, mavContainer, webRequest);
        delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    public abstract void dohandleReturnValue(Object returnValue, MethodParameter returnType,
            ModelAndViewContainer mavContainer, NativeWebRequest webRequest);

    public abstract Class<? extends HandlerMethodReturnValueHandler> getValueHandlerClass();

}
