package jmind.core.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;

/**
 * 
 * @author xieweibo
  * Spring 工具，web启动时自动注入ApplicationContext
 *      <bean id="serviceLocator" class="jmind.core.spring.WebSpringTool"  /> 
 */
public class WebSpringTool extends WebApplicationObjectSupport {
    private static ApplicationContext applicationContext = null;

    @Override
    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        if (applicationContext == null) {
            applicationContext = context;
        }
    }

    public static ApplicationContext getAppContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> beanType) {
        return applicationContext.getBean(beanType);
    }

}
