package jmind.core.spring;

import java.util.Date;

import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequest;

/**
 * 
 * @author xieweibo
 *@see http://blog.csdn.net/cheung1021/article/details/7064809
 * 全局binder配置
 *     <!-- 日期转换  必须放在<mvc:annotation-driven />前面 -->  
        <bean class="org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter">  
            <!-- 日期格式转换 -->  
            <property name="webBindingInitializer">  
                <bean class="jmind.core.spring.SpringBinder" />  
            </property>  
        </bean>  
 */
public class SpringBinder implements WebBindingInitializer {

    @Override
    public void initBinder(WebDataBinder binder, WebRequest request) {

        /**
         * 自动转换日期类型的字段格式 
         */
        //        binder.registerCustomEditor(Date.class, new org.springframework.beans.propertyeditors.CustomDateEditor(
        //                new SimpleDateFormat("yyyy-MM-dd"), true));
        //        binder.registerCustomEditor(Date.class, new org.springframework.beans.propertyeditors.CustomDateEditor(
        //                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));

        //  这里必须每次new 对象。 并发的时候有问题
        binder.registerCustomEditor(Date.class, new CustomDateEditor());
        /**
         * 防止XSS攻击
         * & 会转成  &amp;  只转义 > < 这两个符合
         */
        binder.registerCustomEditor(String.class, new GtLtEditor());
        //   binder.registerCustomEditor(String.class, new StringEscapeEditor(true, false));

        // 设置基本数据类型，默认值为0，防止此参数为空时报错
        binder.registerCustomEditor(int.class, new PrimitiveEditor(Integer.class));
        binder.registerCustomEditor(float.class, new PrimitiveEditor(Float.class));
        binder.registerCustomEditor(long.class, new PrimitiveEditor(Long.class));
        binder.registerCustomEditor(short.class, new PrimitiveEditor(Short.class));
        binder.registerCustomEditor(double.class, new PrimitiveEditor(Double.class));

    }

}
