package jmind.core.spring;

import java.util.List;

import jmind.base.util.DataUtil;

import org.springframework.web.method.support.HandlerMethodReturnValueHandler;

import com.google.common.collect.Lists;

/**
 * http://huangyunbin.iteye.com/blog/2248887
 * @author xieweibo
 * @date 2016年9月20日
 */
public class RequestMappingHandlerAdapter extends
        org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter {

    //    @Override
    //    public void afterPropertiesSet() {
    //
    //        super.afterPropertiesSet();
    //        List<HandlerMethodReturnValueHandler> handlers0 = getReturnValueHandlers();
    //        List<HandlerMethodReturnValueHandler> handlers1 = new ArrayList<>(handlers0.size() + 1);
    //        for (HandlerMethodReturnValueHandler handler : handlers0) {
    //            if (handler instanceof RequestResponseBodyMethodProcessor) {
    //                handlers1.add(new I18nMethodReturnValueHandler(handler));
    //                break;
    //            }
    //        }
    //
    //        handlers1.addAll(handlers0);
    //        setReturnValueHandlers(handlers1);
    //    }
    private List<WrapMethodReturnValueHandler> wrapReturnValueHandlers;

    public void setWrapReturnValueHandlers(List<WrapMethodReturnValueHandler> wrapReturnValueHandlers) {
        this.wrapReturnValueHandlers = wrapReturnValueHandlers;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!DataUtil.isEmpty(wrapReturnValueHandlers)) {
            List<HandlerMethodReturnValueHandler> handlers = Lists.newArrayList();
            for (HandlerMethodReturnValueHandler handle : getReturnValueHandlers()) {
                HandlerMethodReturnValueHandler valueHandler = includeHandler(handle);
                if (valueHandler == null) {
                    handlers.add(handle);
                } else {
                    handlers.add(valueHandler);
                }
            }
            setReturnValueHandlers(handlers);
        }

    }

    private HandlerMethodReturnValueHandler includeHandler(HandlerMethodReturnValueHandler handle) {
        for (WrapMethodReturnValueHandler wrapHandle : wrapReturnValueHandlers) {
            if (wrapHandle.getValueHandlerClass().isInstance(handle)) {
                wrapHandle.setDelegate(handle);
                return wrapHandle;
            }

        }
        return null;
    }

}
