package jmind.core.spring;

import java.beans.PropertyEditorSupport;
import java.util.Date;

import jmind.base.util.DataUtil;
import jmind.base.util.DateUtil;

/**
 * 
 * @author xieweibo
 * @see org.springframework.beans.propertyeditors.CustomDateEditor
 */
public class CustomDateEditor extends PropertyEditorSupport {

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!DataUtil.isEmpty(text)) {
            if (text.length() > 8 && DataUtil.isNumber(text)) {
                long a=DataUtil.toLong(text);
                if(a<Integer.MAX_VALUE){ // 小于int最大值 ，是秒
                    a*=1000;
                }
                setValue(new Date(a));
            } else {
                setValue(DateUtil.parse(text));
            }

        }
    }

}
