package jmind.core.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;

import jmind.base.lang.ScoreValue;

/**
 * http://doc.redisfans.com/
 * @author xieweibo
 * @date 2016年9月13日
 */
public interface Redis {
    /**
     * 获取实例
     * 2014-1-17 
     * @return
     */
    Object getResource();

    /**
     * 释放整个资源
     * 2014-1-8
     */
    void releaseResource();

    /**
     * 关闭单个连接
     * 2014-1-8 
     * @param resource
     */
    public void close(Object resource);

    /**
     * setObject 采用fastjson进行序列化
     * @param key
     * @param o
     * @return
     */
    public boolean setObject(String key, Object o);

    public boolean setObject(String key,int seconds,Object o);

    /**
     * 通过fastjson 转化成对象
     * @param key
     * @param clazz
     * @param <T>
     * @return
     */
    public <T> T getObject(String key, Class<T> clazz);

    public <T> List<T> getArray(String key,Class<T> clazz);

    String set(String key, String value);

    public long del(String... keys);

    String get(String key);

    List<String> mget(String... key);

    Boolean exists(String key);

    String type(String key);

    boolean expire(String key, int seconds);

    boolean expireAt(String key, long unixTime);

    Long ttl(String key);

    Long setbit(String key, long offset, int value);

    Long getbit(String key, long offset);

    Long setrange(String key, long offset, String value);

    String getrange(String key, long startOffset, long endOffset);

    String getSet(String key, String value);

    Long setnx(String key, String value);

    String setex(String key, int seconds, String value);

    Long decrBy(String key, long integer);

    Long decr(String key);

    Long incrBy(String key, long integer);

    Long incr(String key);

    Long append(String key, String value);

    String substr(String key, int start, int end);

    Long hset(String key, String field, String value);

    String hget(String key, String field);

    Long hsetnx(String key, String field, String value);

    String hmset(String key, Map<String, String> hash);

    List<String> hmget(String key, String... fields);

    Long hincrBy(String key, String field, long value);

    Boolean hexists(String key, String field);

    Long hdel(String key, String... field);

    Long hlen(String key);

    Set<String> hkeys(String key);

    List<String> hvals(String key);

    Map<String, String> hgetAll(String key);

    Long rpush(String key, String... string);

    Long lpush(String key, String... string);

    Long llen(String key);

    List<String> lrange(String key, long start, long end);

    List<String> lrevrange(String key, long start, long end);

    String ltrim(String key, long start, long end);

    String lindex(String key, long index);

    String lset(String key, long index, String value);

    Long lrem(String key, long count, String value);

    String lpop(String key);

    String rpop(String key);

    Long sadd(String key, String... member);

    Set<String> smembers(String key);

    Long srem(String key, String... member);

    String spop(String key);

    Long scard(String key);

    Boolean sismember(String key, String member);

    String srandmember(String key);

    Long zadd(String key, double score, String member);

    /**
     * 不理解为什么jedis 用score作为key，score相同怎么办？
     * 2014-3-21 
     * @param key
     * @param scoreMembers
     * @return
     */

    /**
     * 由于score值可能相同，所以score做key不科学，应该用member做key
     * 2014-3-21 
     * @param key
     * @param scoreMembers
     * @return
     */
    Long zadd(String key, Map<String, Double> memberScore);

    List<String> zrange(String key, long start, long end);

    Long zrem(String key, String... member);

    Double zincrby(String key, double score, String member);

    Long zrank(String key, String member);

    Long zrevrank(String key, String member);

    List<String> zrevrange(String key, long start, long end);

    List<ScoreValue<String>> zrangeWithScores(String key, long start, long end);

    //
    List<ScoreValue<String>> zrevrangeWithScores(String key, long start, long end);

    Long zcard(String key);

    Double zscore(String key, String member);

    List<String> sort(String key);

    // List<String> sort(String key, SortingParams sortingParameters);

    Long zcount(String key, double min, double max);

    Long zcount(String key, String min, String max);

    List<String> zrangeByScore(String key, double min, double max);

    List<String> zrangeByScore(String key, String min, String max);

    List<String> zrevrangeByScore(String key, double max, double min);

    List<String> zrangeByScore(String key, double min, double max, int offset, int count);

    List<String> zrangeByScore(String key, String min, String max, int offset, int count);

    List<String> zrevrangeByScore(String key, double max, double min, int offset, int count);

    List<String> zrevrangeByScore(String key, String max, String min, int offset, int count);

    Long zremrangeByRank(String key, long start, long end);

    Long zremrangeByScore(String key, double start, double end);

    Long linsert(String key, boolean before, String pivot, String value);

    Long lpushx(String key, String string);

    Long rpushx(String key, String string);

    List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max);

    //
    List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min);

    //
    List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count);

    //  List<ScoreValue<String>> zrangeByScoreWithScores(String key, String min, String max);

    //   List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, String max, String min);

    //   List<ScoreValue<String>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count);

    List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count);

    //  List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count);

}
