package jmind.core.rabbitmq;

import com.rabbitmq.client.AMQP;

/**
 * Created by xieweibo on 2016/11/3.
 */
public interface Producer {

    public boolean produce(String routingKey,String message);

    /**
     * 发送mq消息
     * @param exchange 消息交换机，它指定消息按什么规则，路由到哪个队列
     * @param routingKey 路由关键字，exchange根据这个关键字进行消息投递
     * @param message  消息内容
     * @return
     */
    public boolean produce(String exchange,String routingKey,String message);

    /**
     *
     * @param exchange
     * @param routingKey
     * @param delayTime 延时时间，毫秒
     * @param message
     * @return
     */
    public boolean produce(String exchange,String routingKey,int delayTime,String message);

    boolean produce(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) ;
}
