package jmind.core.manager;

import jmind.core.cache.support.XMemCache;
import jmind.core.cache.xmemcached.MemcachedBuilder;
import net.rubyeye.xmemcached.XMemcachedClient;

/**
 * memcached.common.hosts  192.168.75.84:11211 192.168.75.83:11211
 * @author wbxie
 * 2014-3-4
 */
public class XMemCacheManager extends AbstractManager<XMemCache> {

    private static volatile XMemCacheManager manager = null;

    public static XMemCacheManager getInstance() {
        if (manager == null) {
            synchronized (XMemCacheManager.class) {
                if (manager == null) {
                    manager = new XMemCacheManager();
                }
            }
        }
        return manager;
    }

    @Override
    public XMemCache create(String name) {
        return new XMemCache(new MemcachedBuilder(getProperties(), name).client());
    }

    /**
     *@see XMemcachedClient.startConnector
     *xmem 自己有停机关闭，不需要实现
     */
    @Override
    public void releaseResource() {

    }

}
